/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.AlexandriaDisplay;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.HideListener;
import io.intino.alexandria.ui.displays.events.ShowListener;
import io.intino.alexandria.ui.displays.notifiers.ComponentNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class Component<DN extends ComponentNotifier, B extends Box>
extends AlexandriaDisplay<DN, B> {
    private String color;
    private boolean visible = true;
    private List<ShowListener> showListeners = new ArrayList<ShowListener>();
    private List<HideListener> hideListeners = new ArrayList<HideListener>();

    protected Component(B box) {
        super(box);
    }

    public String color() {
        return this.color;
    }

    public Component<DN, B> color(String color) {
        this._color(color);
        ((ComponentNotifier)this.notifier).refreshColor(color);
        return this;
    }

    public Component<DN, B> formats(Set<String> formats) {
        ((ComponentNotifier)this.notifier).refreshFormat(String.join((CharSequence)" ", formats));
        return this;
    }

    public Component<DN, B> onShow(ShowListener listener) {
        this.showListeners.add(listener);
        return this;
    }

    public Component<DN, B> onHide(HideListener listener) {
        this.hideListeners.add(listener);
        return this;
    }

    public void notifyUser(String message, UserMessage.Type messageType) {
        int duration = messageType == UserMessage.Type.Loading ? -1 : (messageType == UserMessage.Type.Error ? 5000 : 2500);
        this.notifyUser(message, messageType, duration);
    }

    public void notifyUser(String message, UserMessage.Type messageType, int autoHideDuration) {
        ((ComponentNotifier)this.notifier).userMessage(new UserMessage().message(message).type(messageType).autoHideDuration(autoHideDuration));
    }

    public void hideUserNotification() {
        ((ComponentNotifier)this.notifier).hideUserMessage();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isHidden() {
        return !this.visible;
    }

    public boolean visible() {
        return this.visible;
    }

    public <T extends Component> T visible(boolean value) {
        this.updateVisibility(value);
        return (T)this;
    }

    public Component<DN, B> show() {
        this.updateVisibility(true);
        return this;
    }

    public Component<DN, B> hide() {
        this.updateVisibility(false);
        return this;
    }

    protected Component _color(String color) {
        this.color = color;
        return this;
    }

    protected void updateVisible(boolean value) {
        this.visible = value;
    }

    protected void updateVisibility(boolean value) {
        this.updateVisible(value);
        ((ComponentNotifier)this.notifier).refreshVisibility(value);
        this.notifyVisibility();
    }

    protected void notifyVisibility() {
        if (this.visible) {
            this.showListeners.forEach(l -> l.accept(new Event(this)));
        }
        if (!this.visible) {
            this.hideListeners.forEach(l -> l.accept(new Event(this)));
        }
    }
}

