package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Timeline;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.spark.UISparkManager;

public class TimelinePushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		Timeline display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("openHistory")) {
			display.openHistory(data);
			return;
		}
		else if (operation.equals("historyWithRelativeValues")) {
			display.historyWithRelativeValues(io.intino.alexandria.Json.fromString(data, Boolean.class));
			return;
		}
		else if (operation.equals("fetch")) {
			display.fetch(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.TimelineHistoryFetch.class));
			return;
		}
		else if (operation.equals("magnitudesVisibility")) {
			display.magnitudesVisibility(java.util.List.of(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.TimelineMagnitudeVisibility[].class)));
			return;
		}
		else if (operation.equals("magnitudesSorting")) {
			display.magnitudesSorting(java.util.List.of(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.TimelineMagnitudeSorting[].class)));
			return;
		}

		super.execute(client, message);
	}

}