package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.SelectNextItem;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class SelectNextItemRequester extends ActionableRequester {

	public SelectNextItemRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SelectNextItem display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("execute")) {
			display.execute();
			return;
		}

		super.execute();
	}
}