/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.resources;

import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.DisplayRouter;
import io.intino.alexandria.ui.displays.RouteDispatcher;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.pages.WidgetTypeMobilePage;
import io.intino.alexandria.ui.pages.WidgetTypePage;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.pages.UiPage;
import io.intino.alexandria.ui.spark.resources.Resource;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class WidgetTypeResource
extends Resource {
    private final UiFrameworkBox box;

    public WidgetTypeResource(UiFrameworkBox box, UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    @Override
    public void execute() throws AlexandriaException {
        super.execute();
        this.fillDeviceParameter();
        this.render();
    }

    private void render() {
        String clientId = UUID.randomUUID().toString();
        final UiPage page = this.manager.fromQuery("device") != null ? new WidgetTypeMobilePage() : new WidgetTypePage();
        page.session = this.manager.currentSession();
        page.session.browser().onRedirect(location -> this.manager.redirect((String)location));
        page.session.browser().requestUrl(this.manager.requestUrl());
        page.session.whenLogin(new Function<String, String>(){

            @Override
            public String apply(String baseUrl) {
                return WidgetTypeResource.this.authenticate(page.session, baseUrl);
            }
        });
        page.session.whenLogout(b -> this.logout(page.session));
        if (page instanceof WidgetTypeMobilePage) {
            ((WidgetTypeMobilePage)page).box = this.box;
        } else {
            ((WidgetTypePage)page).box = this.box;
        }
        page.clientId = clientId;
        page.googleApiKey = "AIzaSyA8FjeAX36umrYD8Jk2FbRFWqDEulInKIA";
        page.device = this.parameterValue("device");
        page.token = this.parameterValue("token");
        if (page instanceof WidgetTypeMobilePage) {
            ((WidgetTypeMobilePage)page).type = this.parameterValue("type");
        } else {
            ((WidgetTypePage)page).type = this.parameterValue("type");
        }
        if (!page.hasPermissions()) {
            this.manager.redirect(page.redirectUrl());
            return;
        }
        ((PushService)this.manager.pushService()).onOpen(client -> {
            if (!client.id().equals(page.clientId)) {
                return false;
            }
            if (client.soul() != null) {
                ((RouteDispatcher)this.box.routeManager().routeDispatcher()).dispatchWidgetType((Soul)client.soul(), page instanceof WidgetTypeMobilePage ? ((WidgetTypeMobilePage)page).type : ((WidgetTypePage)page).type);
                return false;
            }
            Soul soul = page.prepareSoul((UIClient)((Object)client));
            soul.onRedirect(location -> this.manager.redirect((String)location));
            soul.addRegisterDisplayListener(display -> {
                display.inject(this.notifier(page.session, (UIClient)((Object)client), (Display)display));
                display.inject(page.session);
                display.inject(soul);
                display.inject(() -> soul);
            });
            client.soul(soul);
            client.cookies(this.manager.cookies());
            this.box.registerSoul(clientId, soul);
            soul.register(new DisplayRouter<UiFrameworkBox>(this.box).id("__router__"));
            ((RouteDispatcher)this.box.routeManager().routeDispatcher()).dispatchWidgetType(soul, page instanceof WidgetTypeMobilePage ? ((WidgetTypeMobilePage)page).type : ((WidgetTypePage)page).type);
            return true;
        });
        ((PushService)this.manager.pushService()).onClose(clientId).execute((Consumer)new Consumer<UIClient>(){

            @Override
            public void accept(UIClient client) {
                WidgetTypeResource.this.box.soul(client.id()).ifPresent(s -> s.destroy());
                WidgetTypeResource.this.box.unRegisterSoul(client.id());
                WidgetTypeResource.this.manager.unRegister(client);
            }
        });
        this.manager.write(page.execute());
    }
}

