/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.documentation.model.data;

import io.intino.alexandria.schemas.Property;
import io.intino.alexandria.ui.documentation.Model;
import io.intino.alexandria.ui.documentation.model.BaseWidget;
import java.util.Arrays;
import java.util.Collections;

public class FileWidget
extends BaseWidget {
    public FileWidget() {
        super("This widget allows both uploading or preview files of different types.");
        this.facets(Arrays.asList("Absolute", "Relative"));
    }

    @Override
    protected void addProperties() {
        super.addProperties();
        this.add(Model.property("value", Property.Type.Text, "File for widget. It must be a resource directory relative path to file.", new String[0]));
        this.add(Model.property("width", Property.Type.Integer, "Width of preview visor in pixels with Absolute facet or percentage with Relative facet", new String[0]).facets(Arrays.asList("Absolute", "Relative")));
        this.add(Model.property("height", Property.Type.Integer, "Height of preview visor in pixels with Absolute facet or percentage with Relative facet", new String[0]).facets(Arrays.asList("Absolute", "Relative")));
    }

    @Override
    protected void addMethods() {
        super.addMethods();
        this.addMethod(Model.method("value", Collections.emptyList(), "Returns value stored in widget", "java.net.URL"));
        this.addMethod(Model.method("update", Collections.singletonList(Model.methodParameter("value", "java.net.URL")), "Updates file value and refresh widget", "Void"));
    }

    @Override
    protected void addEvents() {
        super.addEvents();
        this.addEvent(Model.method("onChange", Collections.singletonList(Model.methodParameter("listener", "io.intino.alexandria.ui.displays.events.ChangeListener")), "This event is fired when widget value changes", "void").facets(Collections.singletonList("Editable")));
    }
}

