/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Resource;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractImageEditable;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.events.ReadonlyEvent;
import io.intino.alexandria.ui.displays.events.ReadonlyListener;
import io.intino.alexandria.ui.displays.notifiers.ImageEditableNotifier;
import io.intino.alexandria.ui.resources.Asset;
import io.intino.alexandria.ui.spark.UIFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class ImageEditable<DN extends ImageEditableNotifier, B extends Box>
extends AbstractImageEditable<DN, B>
implements Editable<DN, B> {
    private URL defaultValue;
    private boolean readonly;
    public ChangeListener changeListener = null;
    private Listener uploadingListener = null;
    private ReadonlyListener readonlyListener = null;

    public ImageEditable(B box) {
        super(box);
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public void reload() {
        ((ImageEditableNotifier)this.notifier).refresh(this.serializedValue());
    }

    @Override
    public ImageEditable<DN, B> focus() {
        ((ImageEditableNotifier)this.notifier).refreshFocused(true);
        return this;
    }

    @Override
    public ImageEditable<DN, B> readonly(boolean readonly) {
        this._readonly(readonly);
        this.notifyReadonly(readonly);
        return this;
    }

    public UIFile download() {
        return new UIFile(){

            @Override
            public String label() {
                if (ImageEditable.this.filename() != null) {
                    return URLEncoder.encode(ImageEditable.this.filename(), StandardCharsets.UTF_8);
                }
                String path = ImageEditable.this.value().getPath();
                return path.contains("/") ? path.substring(path.lastIndexOf("/") + 1) : path;
            }

            @Override
            public InputStream content() {
                try {
                    if (ImageEditable.this.value() != null) {
                        return ImageEditable.this.value().openStream();
                    }
                    if (ImageEditable.this.defaultValue != null) {
                        return ImageEditable.this.defaultValue.openStream();
                    }
                    return new ByteArrayInputStream(new byte[0]);
                }
                catch (IOException ignored) {
                    return new ByteArrayInputStream(new byte[0]);
                }
            }
        };
    }

    public ImageEditable<DN, B> onUploading(Listener listener) {
        this.uploadingListener = listener;
        return this;
    }

    @Override
    public ImageEditable<DN, B> onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    @Override
    public ImageEditable<DN, B> onReadonly(ReadonlyListener listener) {
        this.readonlyListener = listener;
        return this;
    }

    public void notifyUploading() {
        if (this.uploadingListener != null) {
            this.uploadingListener.accept(new Event(this));
        }
    }

    public void notifyChange(Resource value) {
        if (this.changeListener != null) {
            this.changeListener.accept(new ChangeEvent(this, value));
        }
    }

    protected ImageEditable<DN, B> _defaultValue(URL defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    protected ImageEditable<DN, B> _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    @Override
    String serializedValue() {
        String result = null;
        if (this.value() != null) {
            result = Asset.toResource(this.baseAssetUrl(), this.value()).toUrl().toString();
        } else if (this.defaultValue != null) {
            result = Asset.toResource(this.baseAssetUrl(), this.defaultValue).toUrl().toString();
        }
        return result;
    }

    private void notifyReadonly(boolean value) {
        if (this.readonlyListener != null) {
            this.readonlyListener.accept(new ReadonlyEvent(this, value));
        }
        ((ImageEditableNotifier)this.notifier).refreshReadonly(value);
    }
}

