/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.CollectionMoreItems;
import io.intino.alexandria.schemas.DynamicTableData;
import io.intino.alexandria.schemas.DynamicTableRowParams;
import io.intino.alexandria.schemas.DynamicTableRowsParams;
import io.intino.alexandria.schemas.DynamicTableSetup;
import io.intino.alexandria.schemas.DynamicTableVisibleColumn;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractDynamicTable;
import io.intino.alexandria.ui.displays.components.Row;
import io.intino.alexandria.ui.displays.components.collection.Collection;
import io.intino.alexandria.ui.displays.components.collection.behaviors.DynamicTableCollectionBehavior;
import io.intino.alexandria.ui.displays.components.collection.builders.DynamicTableBuilder;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.events.collection.OpenRowEvent;
import io.intino.alexandria.ui.displays.events.collection.OpenRowListener;
import io.intino.alexandria.ui.displays.events.collection.SelectRowsEvent;
import io.intino.alexandria.ui.displays.events.collection.SelectRowsListener;
import io.intino.alexandria.ui.displays.notifiers.DynamicTableNotifier;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.datasource.DynamicTableDatasource;
import io.intino.alexandria.ui.model.dynamictable.Section;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class DynamicTable<B extends Box, ItemComponent extends Row, Item>
extends AbstractDynamicTable<DynamicTableNotifier, B>
implements Collection<ItemComponent, Item> {
    private Listener openingRowListener;
    private OpenRowListener openRowListener;
    private SelectRowsListener selectRowsListener;
    private List<DynamicTableVisibleColumn> visibleColumns = new ArrayList<DynamicTableVisibleColumn>();
    private boolean showZeros = true;
    private boolean showPercentages = false;
    private View view = View.Normal;
    private Function<String, String> translator;

    public DynamicTable(B box) {
        super(box);
    }

    @Override
    public void source(Datasource source) {
        this.source(source, new DynamicTableCollectionBehavior(this));
    }

    public String dimension() {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        if (behavior == null) {
            return null;
        }
        return behavior.dimension();
    }

    public DynamicTable dimension(String dimension) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        if (behavior == null) {
            return this;
        }
        behavior.dimension(dimension);
        return this;
    }

    public String drill() {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        if (behavior == null) {
            return null;
        }
        return behavior.drill();
    }

    public DynamicTable drill(String drill) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        if (behavior == null) {
            return this;
        }
        behavior.drill(drill);
        return this;
    }

    public DynamicTable onOpeningRow(Listener listener) {
        this.openingRowListener = listener;
        return this;
    }

    public DynamicTable onOpenRow(OpenRowListener listener) {
        this.openRowListener = listener;
        return this;
    }

    public DynamicTable onSelectRows(SelectRowsListener listener) {
        this.selectRowsListener = listener;
        return this;
    }

    public DynamicTable openView(View view) {
        ((DynamicTableNotifier)this.notifier).openView(view.name());
        return this;
    }

    public DynamicTable translator(Function<String, String> translator) {
        this.translator = translator;
        return this;
    }

    @Override
    protected AddItemEvent itemEvent(Display display, int index) {
        return new AddItemEvent(this, (Row)display, ((Row)display).item(), index);
    }

    @Override
    public String translate(String word) {
        return this.translator != null ? this.translator.apply(word) : super.translate(word);
    }

    @Override
    public void loadMoreItems(CollectionMoreItems info) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.moreItems(info);
    }

    @Override
    public void changePage(Integer page) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.page(page);
        ((DynamicTableNotifier)this.notifier).refresh();
    }

    @Override
    public void changePageSize(Integer size) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.pageSize(size);
        ((DynamicTableNotifier)this.notifier).refresh();
    }

    public List<DynamicTableVisibleColumn> visibleColumns() {
        return this.visibleColumns;
    }

    public DynamicTable<B, ItemComponent, Item> visibleColumns(List<DynamicTableVisibleColumn> visibleColumns) {
        this.visibleColumns = visibleColumns;
        ((DynamicTableNotifier)this.notifier).refreshVisibleColumns(visibleColumns);
        return this;
    }

    public boolean showZeros() {
        return this.showZeros;
    }

    public DynamicTable<B, ItemComponent, Item> showZeros(Boolean value) {
        this.showZeros = value;
        ((DynamicTableNotifier)this.notifier).refreshZeros(value);
        return this;
    }

    public boolean showPercentages() {
        return this.showPercentages;
    }

    public DynamicTable<B, ItemComponent, Item> showPercentages(Boolean value) {
        this.showPercentages = value;
        ((DynamicTableNotifier)this.notifier).refreshPercentages(value);
        return this;
    }

    @Override
    public ItemComponent add(Item item) {
        Row component = (Row)this.create(item);
        this.addPromise(component, "rows");
        return (ItemComponent)component;
    }

    @Override
    public List<ItemComponent> add(List<Item> items) {
        List components = items.stream().map(this::create).collect(Collectors.toList());
        this.addPromise(components, "rows");
        return components;
    }

    @Override
    public ItemComponent insert(Item item, int index) {
        Row component = (Row)this.create(item);
        this.insertPromise(component, index, "rows");
        return (ItemComponent)component;
    }

    @Override
    public List<ItemComponent> insert(List<Item> items, int from) {
        List components = items.stream().map(this::create).collect(Collectors.toList());
        this.insertPromise(components, from, "rows");
        return components;
    }

    public void refreshSections(List<Section> sections) {
        ((DynamicTableNotifier)this.notifier).refreshTable(this.table(sections));
        ((DynamicTableNotifier)this.notifier).openRowProvided(this.openRowListener != null);
    }

    private DynamicTableData table(List<Section> sections) {
        DynamicTableData result = new DynamicTableData();
        result.dimension(this.translate(this.dimension()));
        result.drill(this.translate(this.drill()));
        result.sections(DynamicTableBuilder.buildList(sections, this.language()));
        return result;
    }

    public void openRow(DynamicTableRowParams params) {
        if (this.openingRowListener != null) {
            this.openingRowListener.accept(new Event(this));
        }
        if (this.openRowListener == null) {
            return;
        }
        OpenRowEvent event = new OpenRowEvent(this, this.sectionOf(params.section()), params.row());
        ((DynamicTableNotifier)this.notifier).openRow(this.openRowListener.accept(event));
    }

    public void selectRows(List<DynamicTableRowsParams> selection) {
        if (this.selectRowsListener == null) {
            return;
        }
        SelectRowsEvent event = new SelectRowsEvent(this, this.toMap(selection));
        this.selectRowsListener.accept(event);
    }

    public void showItems(DynamicTableRowParams params) {
        Section section = this.sectionOf(params.section());
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.section(section);
        behavior.row(params.row());
        behavior.reload();
        ((DynamicTableNotifier)this.notifier).setupDynamicTable((DynamicTableSetup)new DynamicTableSetup().visibleColumns(this.visibleColumns).openRowExternal(this.openRowListener != null).selectRowsEnabled(this.selectRowsListener != null).pageSize(this.pageSize()).itemCount(behavior.itemCount()));
    }

    private Section sectionOf(String section) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        List<Section> sections = behavior.sections();
        return sections.stream().filter((? super T s) -> s.label().equals(section)).findFirst().orElse(null);
    }

    @Override
    public void didMount() {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        DynamicTableDatasource source = (DynamicTableDatasource)this.source();
        ((DynamicTableNotifier)this.notifier).setupDynamicTable((DynamicTableSetup)new DynamicTableSetup().visibleColumns(this.visibleColumns).name(source != null ? source.name() : null).openRowExternal(this.openRowListener != null).selectRowsEnabled(this.selectRowsListener != null).pageSize(this.pageSize()).itemCount(behavior.itemCount()));
        this.notifyReady();
    }

    @Override
    void setup() {
        DynamicTableDatasource source = (DynamicTableDatasource)this.source();
        if (source == null) {
            return;
        }
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.setup(source, this.pageSize());
        ((DynamicTableNotifier)this.notifier).setupDynamicTable((DynamicTableSetup)new DynamicTableSetup().visibleColumns(this.visibleColumns).name(source.name()).openRowExternal(this.openRowListener != null).selectRowsEnabled(this.selectRowsListener != null).pageSize(this.pageSize()).itemCount(behavior.itemCount()));
        this.notifyReady();
    }

    private Map<String, List<String>> toMap(List<DynamicTableRowsParams> selection) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        selection.forEach(s -> result.put(s.section(), s.rows()));
        return result;
    }

    public static enum View {
        Normal,
        Indicator;

    }
}

