/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays;

import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRouteDispatcher
implements DisplayRouteDispatcher {
    private static Map<String, String> patterns = new HashMap<String, String>();

    public AbstractRouteDispatcher() {
        this.registerPatterns();
    }

    @Override
    public void dispatch(Soul soul, String address) {
        address = address.replaceFirst(soul.session().browser().basePath(), "");
        List<String> params = this.paramsOf(address);
        if (address.length() <= 1) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("home"))) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("widgets"))) {
            this.dispatchWidgets(soul);
            return;
        }
        if (address.matches(patterns.get("widgetType"))) {
            this.dispatchWidgetType(soul, params.get(0));
            return;
        }
        if (address.matches(patterns.get("microSite"))) {
            this.dispatchMicroSite(soul, params.get(0));
            return;
        }
        if (address.length() <= 1) {
            this.dispatchMobileHome(soul);
            return;
        }
        if (address.matches(patterns.get("mobileHome"))) {
            this.dispatchMobileHome(soul);
            return;
        }
    }

    public abstract void dispatchHome(Soul var1);

    public abstract void dispatchWidgets(Soul var1);

    public abstract void dispatchWidgetType(Soul var1, String var2);

    public abstract void dispatchMicroSite(Soul var1, String var2);

    public abstract void dispatchMobileHome(Soul var1);

    private void registerPatterns() {
        if (patterns.size() > 0) {
            return;
        }
        patterns.put("home", "");
        patterns.put("widgets", "\\/widgets");
        patterns.put("widgetType", "\\/widgets\\/([^\\/]*)");
        patterns.put("microSite", "\\/widgets\\/microsite\\/([^\\/]*)");
        patterns.put("mobileHome", "\\/mobile");
    }

    private String patternOf(String address) {
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("widgets"))) {
            return patterns.get("widgets");
        }
        if (address.matches(patterns.get("widgetType"))) {
            return patterns.get("widgetType");
        }
        if (address.matches(patterns.get("microSite"))) {
            return patterns.get("microSite");
        }
        if (address.matches(patterns.get("mobileHome"))) {
            return patterns.get("mobileHome");
        }
        if (address.matches(patterns.get("mobileHome"))) {
            return patterns.get("mobileHome");
        }
        return null;
    }

    private List<String> paramsOf(String address) {
        return this.paramsOf(address, this.patternOf(address));
    }

    private List<String> paramsOf(String address, String pattern) {
        if (pattern == null) {
            return Collections.emptyList();
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(address);
        if (!m.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i).split("\\?")[0]);
        }
        return this.addQueryStringParams(address, result);
    }

    private List<String> addQueryStringParams(String address, List<String> result) {
        if (address.indexOf("?") == -1) {
            return result;
        }
        String[] parameters = address.split("\\?")[1].split("&");
        for (int i = 0; i < parameters.length; ++i) {
            result.add(parameters[i].split("=")[1]);
        }
        return result;
    }
}

