/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.schemas.TimelineHistoryFetch;
import io.intino.alexandria.schemas.TimelineMagnitudeSorting;
import io.intino.alexandria.schemas.TimelineMagnitudeVisibility;
import io.intino.alexandria.ui.displays.components.Timeline;
import io.intino.alexandria.ui.displays.requesters.ComponentPushRequester;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import java.util.List;

public class TimelinePushRequester
extends ComponentPushRequester {
    @Override
    public void execute(UIClient client, UIMessage message) {
        Timeline display = (Timeline)this.display(client, message);
        if (display == null) {
            return;
        }
        String operation = this.operation(message);
        String data = this.data(message);
        if (operation.equals("openHistory")) {
            display.openHistory(data);
            return;
        }
        if (operation.equals("historyWithRelativeValues")) {
            display.historyWithRelativeValues((Boolean)Json.fromString((String)data, Boolean.class));
            return;
        }
        if (operation.equals("fetch")) {
            display.fetch((TimelineHistoryFetch)Json.fromString((String)data, TimelineHistoryFetch.class));
            return;
        }
        if (operation.equals("magnitudesVisibility")) {
            display.magnitudesVisibility(List.of((TimelineMagnitudeVisibility[])Json.fromString((String)data, TimelineMagnitudeVisibility[].class)));
            return;
        }
        if (operation.equals("magnitudesSorting")) {
            display.magnitudesSorting(List.of((TimelineMagnitudeSorting[])Json.fromString((String)data, TimelineMagnitudeSorting[].class)));
            return;
        }
        super.execute(client, message);
    }
}

