package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.TextEditable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class TextEditableRequester extends BaseTextRequester {

	public TextEditableRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		TextEditable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("notifyChange")) {
			display.notifyChange(manager.fromQuery("v"));
			return;
		}
		else if (operation.equals("notifyKeyPress")) {
			display.notifyKeyPress(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.KeyPressEventData.class));
			return;
		}
		else if (operation.equals("notifyFocus")) {
			display.notifyFocus();
			return;
		}
		else if (operation.equals("notifyBlur")) {
			display.notifyBlur(manager.fromQuery("v"));
			return;
		}

		super.execute();
	}
}