package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.SelectorComboBox;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.spark.UISparkManager;

public class SelectorComboBoxPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		SelectorComboBox display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("updateSelection")) {
			display.updateSelection(java.util.List.of(io.intino.alexandria.Json.fromString(data, String[].class)));
			return;
		}
		else if (operation.equals("opened")) {
			display.opened();
			return;
		}

		super.execute(client, message);
	}

}