package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.LocationEditable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class LocationEditableRequester extends BaseLocationRequester {

	public LocationEditableRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		LocationEditable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("notifyChange")) {
			display.notifyChange(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.Geometry.class));
			return;
		}

		super.execute();
	}
}