package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Actionable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class ActionableRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public ActionableRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Actionable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("setupSign")) {
			display.setupSign(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.ActionableSign.class));
			return;
		}
		else if (operation.equals("checkSign")) {
			display.checkSign(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.ActionableSign.class));
			return;
		}
		else if (operation.equals("checkAffirmed")) {
			display.checkAffirmed();
			return;
		}
		else if (operation.equals("cancelAffirm")) {
			display.cancelAffirm(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), Boolean.class));
			return;
		}
		else if (operation.equals("beforeSigned")) {
			display.beforeSigned();
			return;
		}

		super.execute();
	}
}