/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.drivers.Driver;
import io.intino.alexandria.drivers.Program;
import io.intino.alexandria.drivers.program.Resource;
import io.intino.alexandria.drivers.program.Script;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.schemas.DashboardShinyInfo;
import io.intino.alexandria.schemas.DashboardShinySettingsInfo;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.AbstractDashboardShiny;
import io.intino.alexandria.ui.displays.components.dashboard.DashboardManager;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.notifiers.DashboardShinyNotifier;
import io.intino.alexandria.ui.utils.DelayerUtil;
import io.intino.alexandria.ui.utils.IOUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;

public class DashboardShiny<DN extends DashboardShinyNotifier, B extends Box>
extends AbstractDashboardShiny<DN, B> {
    private Driver driver;
    private URL serverScript;
    private URL uiScript;
    private List<URL> resourceList = new ArrayList<URL>();
    private DashboardNameProvider dashboardNameProvider = null;
    private Listener closeSettingsListener = null;

    public DashboardShiny(B box) {
        super(box);
    }

    public DashboardShiny<DN, B> serverScript(URL script) {
        this._serverScript(script);
        return this;
    }

    public DashboardShiny<DN, B> uiScript(URL script) {
        this._uiScript(script);
        return this;
    }

    public DashboardShiny<DN, B> addResource(URL resource) {
        this.resourceList.add(resource);
        return this;
    }

    public DashboardShiny dashboardNameProvider(DashboardNameProvider provider) {
        this.dashboardNameProvider = provider;
        return this;
    }

    public DashboardShiny onCloseSettings(Listener listener) {
        this.closeSettingsListener = listener;
        return this;
    }

    public DashboardShiny driver(Driver driver) {
        this.driver = driver;
        return this;
    }

    protected DashboardShiny _serverScript(URL script) {
        this.serverScript = script;
        return this;
    }

    protected DashboardShiny _uiScript(URL script) {
        this.uiScript = script;
        return this;
    }

    protected DashboardShiny _add(URL resource) {
        this.resourceList.add(resource);
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.refresh();
    }

    @Override
    public void refresh() {
        try {
            ((DashboardShinyNotifier)this.notifier).showLoading();
            final String location = this.execute();
            Timer timer = new Timer("Dashboard notifier");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ((DashboardShinyNotifier)DashboardShiny.this.notifier).refresh(new DashboardShinyInfo().location(location).driverDefined(DashboardShiny.this.driver != null).adminMode(DashboardShiny.this.adminMode()));
                }
            }, 1000L);
        }
        catch (RuntimeException ex) {
            ((DashboardShinyNotifier)this.notifier).refreshError(ex.getMessage());
        }
    }

    public void showSettings() {
        ((DashboardShinyNotifier)this.notifier).showSettings(new DashboardShinySettingsInfo().serverScript(this.contentOf(this.serverScript)).uiScript(this.contentOf(this.uiScript)));
    }

    public void hideSettings() {
        ((DashboardShinyNotifier)this.notifier).hideSettings();
        if (this.closeSettingsListener != null) {
            this.closeSettingsListener.accept(new Event(this));
        }
    }

    public void saveServerScript(String content) {
        this.saveScript(this.serverScript, this.decode(content));
        DelayerUtil.execute(this, aVoid -> this.notifyUser("Server script saved", UserMessage.Type.Info), 1000);
    }

    public void saveUiScript(String content) {
        this.saveScript(this.uiScript, this.decode(content));
        DelayerUtil.execute(this, aVoid -> this.notifyUser("UI script saved", UserMessage.Type.Info), 1000);
    }

    private String decode(String content) {
        return new String(Base64.getDecoder().decode(content.replace(" ", "+")));
    }

    private String execute() {
        String program = this.programName();
        DashboardManager dashboardManager = new DashboardManager((AlexandriaUiBox)((Object)this.box()), this.session(), program, this.driver);
        if (this.driver == null) {
            return null;
        }
        if (!this.driver.isPublished(program)) {
            this.driver.publish(this.program());
        }
        dashboardManager.listen();
        return dashboardManager.dashboardUrl().toString();
    }

    private Program program() {
        String name = this.programName();
        List<Script> scripts = Arrays.asList(this.scriptOf(this.serverScript), this.scriptOf(this.uiScript));
        List resources = this.resourceList.stream().map(this::resourceOf).collect(Collectors.toList());
        return new Program().name(name).parameters(this.parameters()).scripts(scripts).resources(resources).parameters(this.parameters());
    }

    private Program programOf(URL script) {
        return new Program().name(this.programName()).parameters(this.parameters()).scripts(Collections.singletonList(this.scriptOf(script)));
    }

    private String contentOf(URL file) {
        try {
            return new String(IOUtils.toByteArray(file.openStream()));
        }
        catch (IOException e) {
            return "";
        }
    }

    private Script scriptOf(URL script) {
        try {
            String filename = this.filenameOf(script);
            return new Script().name(filename).content(script.openStream());
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private Resource resourceOf(URL resource) {
        try {
            String filename = this.filenameOf(resource);
            return new Resource().name(filename).content(resource.openStream());
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
            return null;
        }
    }

    private String filenameOf(URL url) {
        String data = url.toString();
        return data.substring(data.lastIndexOf(47) + 1);
    }

    private String programName() {
        return this.dashboardNameProvider != null ? this.dashboardNameProvider.name() : this.name().toLowerCase();
    }

    private void saveScript(URL script, String content) {
        try {
            if (this.driver != null) {
                this.driver.update(this.programOf(script));
            }
            Files.write(Paths.get(script.toURI()), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException | URISyntaxException e) {
            Logger.error((Throwable)e);
        }
    }

    public static interface DashboardNameProvider {
        public String name();
    }
}

