/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.timeline;

import io.intino.alexandria.ui.model.timeline.Formatter;
import java.util.HashMap;
import java.util.Map;

public class MagnitudeDefinition {
    private String name;
    private String unit;
    private Formatter formatter = this.defaultFormatter();
    private final Map<String, String> labelMap = new HashMap<String, String>();

    public String name() {
        return this.name;
    }

    public MagnitudeDefinition name(String name) {
        this.name = name;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public MagnitudeDefinition unit(String unit) {
        this.unit = unit;
        return this;
    }

    public Formatter formatter() {
        return this.formatter;
    }

    public MagnitudeDefinition formatter(Formatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public String label(String language) {
        return this.labelMap.getOrDefault(language, this.name);
    }

    public MagnitudeDefinition add(String language, String label) {
        this.labelMap.put(language, label);
        return this;
    }

    private Formatter defaultFormatter() {
        return value -> String.format("%,.0f", value);
    }
}

