/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.reel;

import io.intino.alexandria.Scale;
import io.intino.alexandria.ui.model.reel.SignalDefinition;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public interface ReelDatasource {
    public String name();

    public List<SignalDefinition> signals();

    public Signal signal(SignalDefinition var1);

    public List<Scale> scales();

    public Instant from(Scale var1);

    public Instant to(Scale var1);

    public Instant previous(Scale var1, Instant var2);

    public Instant next(Scale var1, Instant var2);

    default public SignalDefinition signalDefinition(String name) {
        return this.signals().stream().filter(d -> d.name().equals(name)).findFirst().orElse(null);
    }

    default public Signal signal(String signalName) {
        SignalDefinition signal = this.signalDefinition(signalName);
        return signal != null ? this.signal(signal) : null;
    }

    public static interface Signal {
        public SignalDefinition definition();

        public String reel(Scale var1, Instant var2, Instant var3);

        public Map<Instant, List<Annotation>> annotations(Scale var1, Instant var2, Instant var3);
    }

    public static class Annotation {
        private final String label;
        private final String color;

        public Annotation(String label) {
            this(label, "#ed6c02", Symbol.Circle);
        }

        public Annotation(String label, String color) {
            this(label, color, Symbol.Circle);
        }

        private Annotation(String label, String color, Symbol symbol) {
            this.label = label;
            this.color = color;
        }

        public String label() {
            return this.label;
        }

        public String color() {
            return this.color;
        }

        public static enum Symbol {
            Circle,
            Square,
            Diamond,
            Triangle;

        }
    }
}

