/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.items.Sorting1Mold;
import io.intino.alexandria.ui.displays.items.Sorting2Mold;
import io.intino.alexandria.ui.displays.templates.AbstractSortingExamplesMold;
import io.intino.alexandria.ui.documentation.Person;
import io.intino.alexandria.ui.documentation.model.Datasources;

public class SortingExamplesMold
extends AbstractSortingExamplesMold<AlexandriaUiBox> {
    public SortingExamplesMold(AlexandriaUiBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.list1.source(Datasources.personDatasource());
        this.list1.onAddItem(this::onAddItem);
        this.list2.source(Datasources.personDatasource());
        this.list2.onAddItem(this::onAddItem);
        this.selector.onSelect(event -> this.list2.sortings(event.selection()));
    }

    @Override
    public void refresh() {
        super.refresh();
        this.list1.reload();
        this.list2.reload();
    }

    private void onAddItem(AddItemEvent event) {
        if (event.component() instanceof Sorting1Mold) {
            Sorting1Mold component = (Sorting1Mold)event.component();
            Person person = (Person)event.item();
            component.firstName1.value(person.firstName());
            component.gender1.value(person.gender().name());
            component.age1.value(String.valueOf(person.age()));
        } else if (event.component() instanceof Sorting2Mold) {
            Sorting2Mold component = (Sorting2Mold)event.component();
            Person person = (Person)event.item();
            component.firstName2.value(person.firstName());
            component.gender2.value(person.gender().name());
            component.age2.value(String.valueOf(person.age()));
        }
    }
}

