/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.schemas.Widget;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.items.WidgetListMold;
import io.intino.alexandria.ui.displays.templates.AbstractMobileDocsTemplate;
import io.intino.alexandria.ui.displays.templates.WidgetMold;
import io.intino.alexandria.ui.documentation.DisplayHelper;
import io.intino.alexandria.ui.documentation.Model;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MobileDocsTemplate
extends AbstractMobileDocsTemplate<AlexandriaUiBox> {
    private static final Map<String, String> Labels = new HashMap<String, String>(){
        {
            this.put("dataOption", "Data widgets");
            this.put("catalogOption", "Catalog widgets");
            this.put("operationOption", "Operation widgets");
            this.put("otherOption", "Other widgets");
        }
    };

    public MobileDocsTemplate(AlexandriaUiBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.widgetList.onAddItem(this::refresh);
        this.widgetTypeSelector.onSelect(this::refreshWidgets);
        this.widgetStamp.onBack(e -> this.showCatalogBlock());
        this.open(Model.widget(Model.WidgetType.Export));
    }

    private void refreshWidgets(SelectionEvent event) {
        this.refreshWidgets(!event.selection().isEmpty() ? (String)event.selection().get(0) : null);
    }

    private void refreshWidgets(String group) {
        if (!this.catalogBlock.isVisible()) {
            this.showCatalogBlock();
        }
        this.group.value(this.labelOf(group));
        this.widgetList.source(new WidgetGroupDatasource(group));
        this.widgetList.reload();
    }

    private String labelOf(String option) {
        return Labels.getOrDefault(this.translate(option), option);
    }

    private void refresh(AddItemEvent event) {
        Widget widget = (Widget)event.item();
        WidgetListMold display = (WidgetListMold)event.component();
        display.widgetListItem.onSelect(e -> this.open(widget));
        display.widgetListItem.item(widget);
        display.widgetListItem.refresh();
    }

    private void open(Widget widget) {
        this.showWidgetBlock();
        this.widgetStamp.mode(WidgetMold.Mode.Embedded);
        this.widgetStamp.item(widget);
    }

    private void showCatalogBlock() {
        this.catalogBlock.show();
        this.widgetBlock.hide();
    }

    private void showWidgetBlock() {
        this.catalogBlock.hide();
        this.widgetBlock.show();
    }

    private static class WidgetGroupDatasource
    extends PageDatasource<Widget> {
        private final String group;
        private static final Map<String, List<Model.WidgetType>> Widgets = new HashMap<String, List<Model.WidgetType>>(){
            {
                this.put("dataOption", List.of(Model.WidgetType.Text, Model.WidgetType.Number, Model.WidgetType.Image, Model.WidgetType.File, Model.WidgetType.Date, Model.WidgetType.Location, Model.WidgetType.Multiple, Model.WidgetType.DigitalSignature));
                this.put("catalogOption", List.of(Model.WidgetType.List, Model.WidgetType.Table, Model.WidgetType.DynamicTable, Model.WidgetType.Grid, Model.WidgetType.Map, Model.WidgetType.Grouping, Model.WidgetType.GroupingToolbar, Model.WidgetType.Sorting, Model.WidgetType.SearchBox));
                this.put("operationOption", List.of(Model.WidgetType.OpenPage, Model.WidgetType.Export, Model.WidgetType.Download, Model.WidgetType.DownloadSelection));
                this.put("otherOption", List.of(Model.WidgetType.Block, Model.WidgetType.Chart, Model.WidgetType.Dashboard, Model.WidgetType.AppDirectory, Model.WidgetType.Slider, Model.WidgetType.Dialog, Model.WidgetType.Layer, Model.WidgetType.Divider, Model.WidgetType.User, Model.WidgetType.Selector, Model.WidgetType.Stepper, Model.WidgetType.Frame, Model.WidgetType.MicroSite, Model.WidgetType.HtmlViewer, Model.WidgetType.DateNavigator, Model.WidgetType.Timeline, Model.WidgetType.Eventline, Model.WidgetType.Reel, Model.WidgetType.DocumentEditor, Model.WidgetType.Kpi));
            }
        };

        public WidgetGroupDatasource(String group) {
            this.group = group;
        }

        @Override
        public List<Widget> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
            List<Widget> result = this.sort(this.load(condition, filters), sortings);
            int from = Math.min(start, result.size());
            int end = Math.min(start + count, result.size());
            return result.subList(from, end);
        }

        @Override
        public long itemCount(String condition, List<Filter> filters) {
            return this.load(condition, filters).size();
        }

        @Override
        public List<Group> groups(String key) {
            return Collections.emptyList();
        }

        private List<Widget> load(String condition, List<Filter> filters) {
            return Widgets.getOrDefault(this.group, Collections.emptyList()).stream().map(Model::widget).collect(Collectors.toList());
        }

        private List<Widget> sort(List<Widget> widgetList, List<String> sortings) {
            widgetList.sort(Comparator.comparing(DisplayHelper::name));
            return widgetList;
        }
    }
}

