/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.items.Grouping1Mold;
import io.intino.alexandria.ui.displays.items.Grouping2Mold;
import io.intino.alexandria.ui.displays.templates.AbstractGroupingExamplesMold;
import io.intino.alexandria.ui.documentation.Person;
import io.intino.alexandria.ui.documentation.model.Datasources;
import io.intino.alexandria.ui.model.datasource.Group;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class GroupingExamplesMold
extends AbstractGroupingExamplesMold<AlexandriaUiBox> {
    public GroupingExamplesMold(AlexandriaUiBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.list1.source(Datasources.personDatasource());
        this.list1.onAddItem(this::onAddItem);
        this.list2.source(Datasources.personDatasource());
        this.list2.onAddItem(this::onAddItem);
        this.country1.groups(this.countries());
        this.country2.groups(this.countries());
        this.country3.groups(this.countries());
        this.city.groups(Arrays.asList(new Group().label("City1"), new Group().label("City2")));
        this.city.onAttachedChanges(e -> this.notifyUser("City grouping: Country changes its value", UserMessage.Type.Info));
    }

    @Override
    public void refresh() {
        super.refresh();
        this.list1.reload();
        this.list2.reload();
    }

    private void onAddItem(AddItemEvent event) {
        if (event.component() instanceof Grouping1Mold) {
            Grouping1Mold component = (Grouping1Mold)event.component();
            Person person = (Person)event.item();
            component.firstName1.value(person.firstName());
            component.gender1.value(person.gender().name());
            component.age1.value(String.valueOf(person.age()));
        } else if (event.component() instanceof Grouping2Mold) {
            Grouping2Mold component = (Grouping2Mold)event.component();
            Person person = (Person)event.item();
            component.firstName2.value(person.firstName());
            component.gender2.value(person.gender().name());
            component.age2.value(String.valueOf(person.age()));
        }
    }

    private List<Group> countries() {
        return Arrays.asList(this.group("Afghanistan"), this.group("Albania"), this.group("Algeria"), this.group("Andorra"), this.group("Angola"), this.group("Antigua and Barbuda"), this.group("Argentina"), this.group("Armenia"), this.group("Australia"), this.group("Austria"), this.group("Azerbaijan"), this.group("Bahamas"), this.group("Bahrain"), this.group("Bangladesh"), this.group("Barbados"), this.group("Belarus"), this.group("Belgium"), this.group("Belize"), this.group("Benin"), this.group("Bhutan"), this.group("Bolivia"), this.group("Bosnia and Herzegovina"), this.group("Botswana"), this.group("Brazil"), this.group("Brunei"), this.group("Bulgaria"), this.group("Burkina Faso"), this.group("Burundi"), this.group("C\u00f4te d'Ivoire"), this.group("Cabo Verde"), this.group("Cambodia"), this.group("Cameroon"), this.group("Canada"), this.group("Central African Republic"), this.group("Chad"), this.group("Chile"), this.group("China"), this.group("Colombia"), this.group("Comoros"), this.group("Congo (Congo-Brazzaville)"), this.group("Costa Rica"), this.group("Croatia"), this.group("Cuba"), this.group("Cyprus"), this.group("Czechia"), this.group("Democratic Republic of the Congo"), this.group("Denmark"), this.group("Djibouti"), this.group("Dominica"), this.group("Dominican Republic"), this.group("Ecuador"), this.group("Egypt"), this.group("El Salvador"), this.group("Equatorial Guinea"), this.group("Eritrea"), this.group("Estonia"), this.group("Ethiopia"), this.group("Fiji"), this.group("Finland"), this.group("France"), this.group("Gabon"), this.group("Gambia"), this.group("Georgia"), this.group("Germany"), this.group("Ghana"), this.group("Greece"), this.group("Grenada"), this.group("Guatemala"), this.group("Guinea"), this.group("Guinea-Bissau"), this.group("Guyana"), this.group("Haiti"), this.group("Holy See"), this.group("Honduras"), this.group("Hungary"), this.group("Iceland"), this.group("India"), this.group("Indonesia"), this.group("Iran"), this.group("Iraq"), this.group("Ireland"), this.group("Israel"), this.group("Italy"), this.group("Jamaica"), this.group("Japan"), this.group("Jordan"), this.group("Kazakhstan"), this.group("Kenya"), this.group("Kiribati"), this.group("Kuwait"), this.group("Kyrgyzstan"), this.group("Laos"), this.group("Latvia"), this.group("Lebanon"), this.group("Lesotho"), this.group("Liberia"), this.group("Libya"), this.group("Liechtenstein"), this.group("Lithuania"), this.group("Luxembourg"), this.group("Madagascar"), this.group("Malawi"), this.group("Malaysia"), this.group("Maldives"), this.group("Mali"), this.group("Malta"), this.group("Marshall Islands"), this.group("Mauritania"), this.group("Mauritius"), this.group("Mexico"), this.group("Micronesia"), this.group("Moldova"), this.group("Monaco"), this.group("Mongolia"), this.group("Montenegro"), this.group("Morocco"), this.group("Mozambique"), this.group("Myanmar (formerly Burma)"), this.group("Namibia"), this.group("Nauru"), this.group("Nepal"), this.group("Netherlands"), this.group("New Zealand"), this.group("Nicaragua"), this.group("Niger"), this.group("Nigeria"), this.group("North Korea"), this.group("North Macedonia"), this.group("Norway"), this.group("Oman"), this.group("Pakistan"), this.group("Palau"), this.group("Palestine State"), this.group("Panama"), this.group("Papua New Guinea"), this.group("Paraguay"), this.group("Peru"), this.group("Philippines"), this.group("Poland"), this.group("Portugal"), this.group("Qatar"), this.group("Romania"), this.group("Russia"), this.group("Rwanda"), this.group("Saint Kitts and Nevis"), this.group("Saint Lucia"), this.group("Saint Vincent and the Grenadines"), this.group("Samoa"), this.group("San Marino"), this.group("Sao Tome and Principe"), this.group("Saudi Arabia"), this.group("Senegal"), this.group("Serbia"), this.group("Seychelles"), this.group("Sierra Leone"), this.group("Singapore"), this.group("Slovakia"), this.group("Slovenia"), this.group("Solomon Islands"), this.group("Somalia"), this.group("South Africa"), this.group("South Korea"), this.group("South Sudan"), this.group("Spain"), this.group("Sri Lanka"), this.group("Sudan"), this.group("Suriname"), this.group("Swaziland"), this.group("Sweden"), this.group("Switzerland"), this.group("Syria"), this.group("Tajikistan"), this.group("Tanzania"), this.group("Thailand"), this.group("Timor-Leste"), this.group("Togo"), this.group("Tonga"), this.group("Trinidad and Tobago"), this.group("Tunisia"), this.group("Turkey"), this.group("Turkmenistan"), this.group("Tuvalu"), this.group("Uganda"), this.group("Ukraine"), this.group("United Arab Emirates"), this.group("United Kingdom"), this.group("United States of America"), this.group("Uruguay"), this.group("Uzbekistan"), this.group("Vanuatu"), this.group("Venezuela"), this.group("Vietnam"), this.group("Yemen"), this.group("Zambia"), this.group("Zimbabwe"));
    }

    private Group group(String label) {
        Random random = new Random();
        return new Group().label(label).count(random.nextInt(1000));
    }
}

