/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.ui.Asset;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.Grid;
import io.intino.alexandria.ui.displays.templates.AbstractGridExamplesMold;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.GridDatasource;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.grid.GridColumn;
import io.intino.alexandria.ui.model.datasource.grid.GridColumnMode;
import io.intino.alexandria.ui.model.datasource.grid.GridGroupBy;
import io.intino.alexandria.ui.model.datasource.grid.GridItem;
import io.intino.alexandria.ui.services.push.UISession;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class GridExamplesMold
extends AbstractGridExamplesMold<UiFrameworkBox> {
    public GridExamplesMold(UiFrameworkBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.grid.itemResolver(new Grid.ItemResolver<GridItem>(){

            @Override
            public GridItem build(GridItem gridItem) {
                return gridItem;
            }

            @Override
            public String address(GridColumn<GridItem> column, GridItem gridItem) {
                return column.address() + "/" + gridItem.values().get(0).asText();
            }
        });
        this.grid.allowMultiSelection(true);
        this.grid.onSelect(e -> {
            List selection = e.selection();
            String message = "Selected rows: " + selection.stream().map(e1 -> e1.values().get(0).asText()).collect(Collectors.joining(", "));
            this.notifyUser(message, UserMessage.Type.Info);
        });
        this.grid.onSortColumn(e -> {
            this.grid.sortings(Collections.emptyList());
            this.notifyUser("Sort by " + e.column().label() + " with mode " + e.mode().name(), UserMessage.Type.Info);
        });
        this.grid.source(new ExampleDatasource(this.session()));
    }

    @Override
    public void refresh() {
        super.refresh();
        this.grid.reload();
    }

    private static class ExampleDatasource
    extends GridDatasource<GridItem> {
        private final UISession session;
        private static final int ColumnCount = 22;
        private static final int RowCount = 1000;

        private ExampleDatasource(UISession session) {
            this.session = session;
        }

        @Override
        public String name() {
            return "grid1";
        }

        @Override
        public List<GridItem> items(int start, int count, String condition, List<Filter> filters, List<String> sortings, GridGroupBy groupBy) {
            List<GridItem> items = this.groupBy(this.load(condition, filters));
            int from = Math.min(start, items.size());
            int end = Math.min(start + count, items.size());
            return items.subList(from, end);
        }

        @Override
        public long itemCount(String condition, List<Filter> filters) {
            return this.load(condition, filters).size();
        }

        @Override
        public long itemCount(String condition, List<Filter> filters, GridGroupBy groupBy) {
            return this.groupBy(this.load(condition, filters)).size();
        }

        @Override
        public List<String> columnGroups(GridColumn<GridItem> column, String mode, String condition, List<Filter> filters) {
            if (mode == null || mode.equals("Distinct values")) {
                return List.of("Lorem ipsum dolor sit amet lorem ipsum", "ipsum dolor sit amet lorem ipsum", "dolor sit amet lorem ipsum", "sit amet lorem ipsum");
            }
            return List.of("lorem", "ipsum", "dolor", "sit");
        }

        @Override
        public List<GridColumnMode> columnModes() {
            return List.of(new GridColumnMode("Distinct values"), new GridColumnMode("First letter", GridColumn.Type.Link, GridColumn.Type.Text), new GridColumnMode("Year", GridColumn.Type.Date), new GridColumnMode("Year and month", GridColumn.Type.Date));
        }

        @Override
        public List<Group> groups(String key) {
            return Collections.emptyList();
        }

        private List<GridItem> load(String condition, List<Filter> filters) {
            ArrayList<GridItem> result = new ArrayList<GridItem>();
            for (int i = 0; i < 1000; ++i) {
                GridItem item = new GridItem();
                for (int j = 0; j < 22; ++j) {
                    if (j == 0) {
                        item.add("Check", "blue");
                        continue;
                    }
                    if (j == 1) {
                        item.add(Asset.toResource(this.urlOf(this.session.browser().baseAssetUrl()), this.randomIcon()).toUrl().toString());
                        continue;
                    }
                    if (j == 3) {
                        item.add(Instant.now());
                        continue;
                    }
                    item.add(i + "." + j);
                }
                result.add(item);
            }
            return result;
        }

        private String randomIcon() {
            double random = Math.random();
            return "/icons/" + (random < 0.5 ? "process.ico" : "task.ico");
        }

        private URL urlOf(String url) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        private List<GridItem> groupBy(List<GridItem> items) {
            return items;
        }
    }
}

