/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.events.collection;

import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.model.datasource.grid.GridColumn;
import java.util.Arrays;

public class SortColumnEvent
extends Event {
    private final GridColumn<?> column;
    private final Mode mode;

    public SortColumnEvent(Display sender, GridColumn<?> column, Mode mode) {
        super(sender);
        this.column = column;
        this.mode = mode;
    }

    public <O> GridColumn<O> column() {
        return this.column;
    }

    public Mode mode() {
        return this.mode;
    }

    public static enum Mode {
        None,
        Ascendant,
        Descendant;


        public static Mode from(String mode) {
            String lowerMode = mode.toLowerCase();
            return Arrays.stream(Mode.values()).filter(m -> m.name().equalsIgnoreCase(mode) || m.name().toLowerCase().startsWith(lowerMode)).findFirst().orElse(null);
        }
    }
}

