/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.KeyPressEventData;
import io.intino.alexandria.schemas.TextEditablePattern;
import io.intino.alexandria.schemas.TextEditablePatternRule;
import io.intino.alexandria.ui.displays.components.AbstractTextEditable;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.components.text.DefaultTextPatternMatcher;
import io.intino.alexandria.ui.displays.components.text.TextPatternMatcher;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.events.KeyPressEvent;
import io.intino.alexandria.ui.displays.events.KeyPressListener;
import io.intino.alexandria.ui.displays.events.ReadonlyEvent;
import io.intino.alexandria.ui.displays.events.ReadonlyListener;
import io.intino.alexandria.ui.displays.notifiers.TextEditableNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TextEditable<DN extends TextEditableNotifier, B extends Box>
extends AbstractTextEditable<DN, B>
implements Editable<DN, B> {
    private boolean readonly;
    private String pattern = null;
    private TextPatternMatcher patternMatcher;
    private ChangeListener changeListener = null;
    private KeyPressListener keyPressListener = null;
    private KeyPressListener enterPressListener = null;
    private ReadonlyListener readonlyListener = null;
    private static final String EnterKeyCode = "Enter";

    public TextEditable(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        if (this.patternMatcher != null) {
            ((TextEditableNotifier)this.notifier).refreshPattern(this.patternSchema());
        }
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public void reload() {
        ((TextEditableNotifier)this.notifier).refresh(this.value());
    }

    @Override
    public TextEditable<DN, B> focus() {
        ((TextEditableNotifier)this.notifier).refreshFocused(true);
        return this;
    }

    @Override
    public TextEditable<DN, B> readonly(boolean readonly) {
        this._readonly(readonly);
        this.notifyReadonly(readonly);
        return this;
    }

    @Override
    public TextEditable<DN, B> onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    @Override
    public TextEditable<DN, B> onReadonly(ReadonlyListener listener) {
        this.readonlyListener = listener;
        return this;
    }

    public TextEditable<DN, B> onKeyPress(KeyPressListener listener) {
        this.keyPressListener = listener;
        return this;
    }

    public TextEditable<DN, B> onEnterPress(KeyPressListener listener) {
        this.enterPressListener = listener;
        return this;
    }

    public TextEditable<DN, B> patternMatcher(TextPatternMatcher matcher) {
        this.patternMatcher = matcher;
        return this;
    }

    public void update(String value) {
        if (!this.notifyChange(value)) {
            return;
        }
        super.value(value);
    }

    public boolean notifyChange(String value) {
        if (this.invalid(value)) {
            return false;
        }
        this._value(value);
        if (this.changeListener != null) {
            this.changeListener.accept(new ChangeEvent(this, this.value()));
        }
        return true;
    }

    @Override
    public String value() {
        String value = super.value();
        return !this.isNullValue(value) ? this.adapt(value) : null;
    }

    public void notifyBlur(String value) {
        if (this.patternMatcher == null) {
            return;
        }
        if (this.invalid(value)) {
            ((TextEditableNotifier)this.notifier).refresh(this.value());
        } else if (!value.equals(this.value())) {
            this.notifyChange(value);
        }
    }

    public void notifyKeyPress(KeyPressEventData data) {
        if (!this.invalid(data.value())) {
            this._value(data.value());
        }
        KeyPressEvent event = new KeyPressEvent(this, data.value(), data.keyCode());
        if (this.keyPressListener != null) {
            this.keyPressListener.accept(event);
        }
        if (this.enterPressListener != null && data.keyCode().equals(EnterKeyCode)) {
            this.enterPressListener.accept(event);
        }
    }

    protected TextEditable<DN, B> _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    protected TextEditable<DN, B> _pattern(String pattern) {
        this.pattern = pattern;
        if (this.patternMatcher == null) {
            this.patternMatcher = new DefaultTextPatternMatcher();
        }
        return this;
    }

    private TextEditablePattern patternSchema() {
        return new TextEditablePattern().value(this.pattern).rules(this.rules()).maskCharacter(String.valueOf(this.patternMatcher.maskCharacter(this.pattern)));
    }

    private List<TextEditablePatternRule> rules() {
        return this.patternMatcher.validationRules().entrySet().stream().map(e -> this.rule((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    private TextEditablePatternRule rule(String name, String value) {
        return new TextEditablePatternRule().name(name).value(value);
    }

    private boolean invalid(String value) {
        if (this.patternMatcher == null) {
            return false;
        }
        if (this.patternMatcher.allowIncompleteValues()) {
            return false;
        }
        if (this.isNullValue(value)) {
            return false;
        }
        return value.contains(String.valueOf(this.patternMatcher.maskCharacter(this.pattern)));
    }

    private boolean isNullValue(String value) {
        if (this.patternMatcher == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        String result = value.replace(String.valueOf(this.patternMatcher.maskCharacter(this.pattern)), "");
        return result.isEmpty() || this.containsAll(this.pattern, result);
    }

    private boolean containsAll(String pattern, String result) {
        for (int i = 0; i < result.length(); ++i) {
            if (pattern.contains(result.substring(i, i + 1))) continue;
            return false;
        }
        return true;
    }

    private String adapt(String value) {
        if (this.patternMatcher == null) {
            return value;
        }
        String result = this.patternMatcher.addSpecialCharactersToValue(this.pattern) ? value : this.valueWithoutSpecialChars(value);
        return this.patternMatcher.allowIncompleteValues() ? result.replace(String.valueOf(this.patternMatcher.maskCharacter(this.pattern)), "") : result;
    }

    private String valueWithoutSpecialChars(String value) {
        List<Integer> positions = this.specialCharsPositions();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (positions.contains(i)) continue;
            result.append(value, i, i + 1);
        }
        return result.toString();
    }

    private List<Integer> specialCharsPositions() {
        Set<String> set = this.patternMatcher.validationRules().keySet();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        String pattern = this.pattern.replace("\\", "");
        for (int i = 0; i < pattern.length(); ++i) {
            if (set.contains(pattern.substring(i, i + 1))) continue;
            positions.add(i);
        }
        return positions;
    }

    private void notifyReadonly(boolean value) {
        if (this.readonlyListener != null) {
            this.readonlyListener.accept(new ReadonlyEvent(this, value));
        }
        ((TextEditableNotifier)this.notifier).refreshReadonly(value);
    }
}

