/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.Selected;
import io.intino.alexandria.ui.displays.components.AbstractSlider;
import io.intino.alexandria.ui.displays.components.slider.Ordinal;
import io.intino.alexandria.ui.displays.components.slider.Range;
import io.intino.alexandria.ui.displays.notifiers.SliderNotifier;

public class Slider<DN extends SliderNotifier, B extends Box>
extends AbstractSlider<DN, B> {
    public Slider(B box) {
        super(box);
        this._value((Object)0);
    }

    @Override
    public void reset() {
        this._value((Object)this.range().min());
    }

    public Slider<DN, B> range(long min, long max) {
        this._range(min, max);
        ((SliderNotifier)this.notifier).refreshRange(this.rangeSchema());
        return this;
    }

    public String formattedValue(long value) {
        return this.format(value);
    }

    public void moved(long value) {
        ((SliderNotifier)this.notifier).refreshSelected(this.schemaOf(value));
        ((SliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
    }

    public void update(long value) {
        this.value(value);
    }

    @Override
    String format(long value) {
        Ordinal ordinal = this.ordinal();
        if (ordinal == null) {
            ordinal = this.defaultOrdinals().get(0);
        }
        return ordinal != null ? ordinal.formatter(this.language()).format(value) : String.valueOf(value);
    }

    @Override
    void updateRange() {
    }

    @Override
    <T extends Selected> void refreshSelected(T schema) {
        ((SliderNotifier)this.notifier).refreshSelected(schema);
    }

    @Override
    protected void _value(Object value) {
        this.value = value instanceof Integer ? Long.valueOf(((Integer)value).intValue()) : value;
    }

    @Override
    protected void _range(long min, long max) {
        this.range = new Range().min(min).max(max);
        long value = (Long)this.value();
        if (value < min) {
            this._value((Object)min);
        }
        if (value > max) {
            this._value((Object)max);
        }
    }

    @Override
    public void previous() {
        this.value((Long)this.value() - 1L);
    }

    @Override
    public void next() {
        this.value((Long)this.value() + 1L);
    }

    @Override
    protected boolean canPrevious() {
        return (Long)this.value() > this.range.min;
    }

    @Override
    protected boolean canNext() {
        return (Long)this.value() < this.range.max;
    }

    @Override
    protected void nextValue() {
        Long value = (Long)this.value();
        if (value >= this.range.max) {
            if (this.canLoop()) {
                this.value(this.range.min() - 1L);
            } else {
                return;
            }
        }
        this.value(value + 1L);
    }

    @Override
    protected boolean checkRange(Object value) {
        if ((Long)value > this.range.max) {
            return false;
        }
        return (Long)value >= this.range.min;
    }

    @Override
    protected Selected schemaOf(Object value) {
        String formattedValue = this.formattedValue((Long)value);
        return new Selected().value((Long)value).formattedValue(formattedValue);
    }
}

