/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractSelectorRadioBox;
import io.intino.alexandria.ui.displays.notifiers.SelectorRadioBoxNotifier;
import java.util.Collections;
import java.util.List;

public class SelectorRadioBox<DN extends SelectorRadioBoxNotifier, B extends Box>
extends AbstractSelectorRadioBox<DN, B> {
    private String selected;

    public SelectorRadioBox(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.selection(this.selected);
    }

    public List<String> selection() {
        return this.selected != null ? Collections.singletonList(this.selected) : Collections.emptyList();
    }

    public void selection(String value) {
        ((SelectorRadioBoxNotifier)this.notifier).refreshSelected(this.nameOf(value));
        if (this.selected != null && this.selected.equals(value)) {
            return;
        }
        this.selected = value;
    }

    public void select(String value) {
        this.selection(value);
        this.notifySelection();
    }

    @Override
    public void reset() {
        this.selected = null;
        ((SelectorRadioBoxNotifier)this.notifier).refreshSelected(null);
    }
}

