/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractSearchBox;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.events.SearchEvent;
import io.intino.alexandria.ui.displays.events.SearchListener;
import io.intino.alexandria.ui.displays.notifiers.SearchBoxNotifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SearchBox<DN extends SearchBoxNotifier, B extends Box>
extends AbstractSearchBox<B> {
    private SearchListener searchListener;
    private List<Collection> collections = new ArrayList<Collection>();
    private String condition = null;

    public SearchBox(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        if (this.condition != null) {
            ((SearchBoxNotifier)this.notifier).refreshCondition(this.condition);
        }
    }

    public SearchBox<DN, B> onSearch(SearchListener listener) {
        this.searchListener = listener;
        return this;
    }

    public SearchBox<DN, B> bindTo(Collection ... collections) {
        this.collections = Arrays.stream(collections).filter(Objects::nonNull).collect(Collectors.toList());
        return this;
    }

    public SearchBox<DN, B> condition(String condition) {
        this.condition = condition;
        ((SearchBoxNotifier)this.notifier).refreshCondition(condition);
        return this;
    }

    public void search(String condition) {
        this.condition = condition;
        this.notifySelected();
    }

    private void notifySelected() {
        this.notifyCollections();
        this.notifyListener();
    }

    private void notifyCollections() {
        this.collections.forEach(c -> c.filter(this.condition));
        if (this.collections.size() > 0) {
            ((SearchBoxNotifier)this.notifier).refreshCount(this.collections.get(0).itemCount());
        }
    }

    private void notifyListener() {
        if (this.searchListener == null) {
            return;
        }
        this.searchListener.accept(new SearchEvent(this, this.condition.trim()));
    }
}

