/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.KpiColors;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractKpi;
import io.intino.alexandria.ui.displays.components.kpi.ValueFormatter;
import io.intino.alexandria.ui.displays.events.SelectEvent;
import io.intino.alexandria.ui.displays.events.SelectListener;
import io.intino.alexandria.ui.displays.notifiers.KpiNotifier;
import java.text.NumberFormat;
import java.util.Locale;

public class Kpi<DN extends KpiNotifier, B extends Box>
extends AbstractKpi<B> {
    private ValueFormatter formatter = this.defaultFormatter();
    private double value;
    private SelectListener selectListener;
    private boolean highlighted = false;

    public Kpi(B box) {
        super(box);
    }

    public Kpi<DN, B> onSelect(SelectListener listener) {
        this.selectListener = listener;
        return this;
    }

    public Kpi<DN, B> formatter(ValueFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public Kpi<DN, B> value(double value) {
        this._value(value);
        this.refresh();
        return this;
    }

    public void select() {
        this.highlighted = !this.highlighted;
        ((KpiNotifier)this.notifier).refreshHighlighted(this.highlighted);
        if (this.selectListener == null) {
            return;
        }
        this.selectListener.accept(new SelectEvent(this, null));
    }

    @Override
    public <D extends Display> D label(String label) {
        super.label(label);
        if (this.notifier != null) {
            ((KpiNotifier)this.notifier).refreshLabel(label);
        }
        return (D)this;
    }

    public Kpi<DN, B> colors(String textColor, String backgroundColor) {
        ((KpiNotifier)this.notifier).refreshColors(new KpiColors().text(textColor).background(backgroundColor));
        return this;
    }

    public Kpi<DN, B> highlighted(boolean value) {
        this.highlighted = value;
        ((KpiNotifier)this.notifier).refreshHighlighted(value);
        return this;
    }

    protected Kpi<DN, B> _value(double value) {
        this.value = value;
        return this;
    }

    @Override
    public void didMount() {
        super.didMount();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        ((KpiNotifier)this.notifier).refresh(this.formatter.format(this.value, this.language()));
    }

    private ValueFormatter defaultFormatter() {
        return new ValueFormatter(){

            @Override
            public String format(double value, String language) {
                return this.formattedNumber(value, Locale.forLanguageTag(language));
            }

            private String formattedNumber(Double value, Locale locale) {
                if (value == null) {
                    return "-";
                }
                return NumberFormat.getNumberInstance(locale).format(this.round(value));
            }

            private double round(double value) {
                long factor = (long)Math.pow(10.0, 2.0);
                long tmp = Math.round(value *= (double)factor);
                return (double)tmp / (double)factor;
            }
        };
    }
}

