/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.GroupingToolbarFilter;
import io.intino.alexandria.ui.displays.components.AbstractGroupingToolbar;
import io.intino.alexandria.ui.displays.components.BaseGrouping;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.components.Grouping;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.events.collection.ApplyFiltersEvent;
import io.intino.alexandria.ui.displays.events.collection.ApplyFiltersListener;
import io.intino.alexandria.ui.displays.notifiers.GroupingToolbarNotifier;
import io.intino.alexandria.ui.model.datasource.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class GroupingToolbar<DN extends GroupingToolbarNotifier, B extends Box>
extends AbstractGroupingToolbar<B> {
    private Map<String, List<String>> filtersMap = new HashMap<String, List<String>>();
    private List<Grouping<?, ?>> groupings = new ArrayList();
    private Listener beforeApplyFiltersListener;
    private ApplyFiltersListener applyFiltersListener;
    private Listener beforeResetFiltersListener;
    private Listener resetFiltersListener;
    private boolean reseting = false;

    public GroupingToolbar(B box) {
        super(box);
    }

    public GroupingToolbar<DN, B> filter(String grouping, List<String> groups) {
        if (groups.size() <= 0) {
            this.filtersMap.remove(grouping);
        } else {
            this.filtersMap.put(grouping, groups);
        }
        if (!this.reseting && this.filtersMap.size() <= 0) {
            this.clearCollections();
        }
        this.refreshFilters();
        return this;
    }

    public GroupingToolbar<DN, B> onBeforeApply(Listener listener) {
        this.beforeApplyFiltersListener = listener;
        return this;
    }

    public GroupingToolbar<DN, B> onApply(ApplyFiltersListener listener) {
        this.applyFiltersListener = listener;
        return this;
    }

    public GroupingToolbar<DN, B> onBeforeReset(Listener listener) {
        this.beforeResetFiltersListener = listener;
        return this;
    }

    public GroupingToolbar<DN, B> onReset(Listener listener) {
        this.resetFiltersListener = listener;
        return this;
    }

    public GroupingToolbar<DN, B> apply() {
        if (this.beforeApplyFiltersListener != null) {
            this.beforeApplyFiltersListener.accept(new Event(this));
        }
        this.collections().forEach(c -> c.filter(this.filtersMap));
        if (this.applyFiltersListener != null) {
            this.applyFiltersListener.accept(new ApplyFiltersEvent(this, this.filtersMap));
        }
        return this;
    }

    public GroupingToolbar<DN, B> reset() {
        this.reseting = true;
        if (this.beforeResetFiltersListener != null) {
            this.beforeResetFiltersListener.accept(new Event(this));
        }
        this.filtersMap.clear();
        this.groupings.forEach(g -> g.select(Collections.emptyList()));
        this.clearCollections();
        if (this.resetFiltersListener != null) {
            this.resetFiltersListener.accept(new Event(this));
        }
        this.reseting = false;
        return this;
    }

    public GroupingToolbar<DN, B> removeFilter(String filter) {
        this.groupingOf(filter).ifPresent(g -> g.select(Collections.emptyList()));
        return this;
    }

    public GroupingToolbar<DN, B> clearFilters() {
        this.reset();
        return this;
    }

    public GroupingToolbar<DN, B> bindTo(Grouping<?, ?> ... groupings) {
        this.groupings.clear();
        this.groupings.addAll(Arrays.asList(groupings));
        this.groupings.forEach(g -> g.bindTo(this));
        return this;
    }

    private void clearCollections() {
        this.collections().forEach(Collection::clearFilters);
    }

    private void refreshFilters() {
        ((GroupingToolbarNotifier)this.notifier).refreshFilters(this.filtersToSchema());
    }

    private List<GroupingToolbarFilter> filtersToSchema() {
        return this.filtersMap.entrySet().stream().map(entry -> {
            Optional<Grouping<?, ?>> grouping = this.groupingOf((String)entry.getKey());
            return this.filterToSchema((String)entry.getKey(), grouping.isPresent() ? grouping.get().groupsOf((List)entry.getValue()) : Collections.emptyList());
        }).collect(Collectors.toList());
    }

    private Optional<Grouping<?, ?>> groupingOf(String key) {
        return this.groupings.stream().filter(g -> g.key().equals(key)).findFirst();
    }

    private GroupingToolbarFilter filterToSchema(String name, List<Group> options) {
        return new GroupingToolbarFilter().name(name).options(options.stream().map(Group::label).collect(Collectors.toList()));
    }

    private List<Collection<?, ?>> collections() {
        return this.groupings.stream().map(BaseGrouping::_collectionBindings).flatMap(java.util.Collection::stream).map(c -> c).distinct().collect(Collectors.toList());
    }
}

