/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.alexandria.ui.services.push.User;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class AlexandriaDisplay<DN extends DisplayNotifier, B extends Box>
extends Display<DN, B> {
    public AlexandriaDisplay(B box) {
        super(box);
    }

    public User user() {
        return this.session().user();
    }

    public String username() {
        UISession session = this.session();
        if (session == null) {
            return null;
        }
        return session.user() != null ? session.user().username() : null;
    }

    @Override
    public URL baseAssetUrl() {
        try {
            return new URL(this.session().browser().baseAssetUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String translate(String word) {
        return ((AlexandriaUiBox)((Object)this.box())).translatorService().translate(word, this.language());
    }

    public String language() {
        return this.session() != null ? this.session().discoverLanguage() : "en";
    }

    public int timezoneOffset() {
        return this.session().timezoneOffset();
    }
}

