package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Reel;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.spark.UISparkManager;

public class ReelPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		Reel display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("fetch")) {
			display.fetch(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.ReelFetch.class));
			return;
		}
		else if (operation.equals("signalsSorting")) {
			display.signalsSorting(java.util.List.of(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.ReelSignalSorting[].class)));
			return;
		}

		super.execute(client, message);
	}

}