package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.FileEditable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class FileEditableRequester extends BaseFileRequester {

	public FileEditableRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		FileEditable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("notifyUploading")) {
			display.notifyUploading();
			return;
		}
		else if (operation.equals("notifyChange")) {
			display.notifyChange(manager.fromFormAsResource("v"));
			return;
		}
		else if (operation.equals("downloadFile")) {
			io.intino.alexandria.ui.spark.UIFile file = display.downloadFile();
			if (file == null) return;
			manager.write(file.content(), file.label(), file.embedded());
			return;
		}

		super.execute();
	}
}