package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Eventline;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class EventlineRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public EventlineRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Eventline display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("update")) {
			display.update(manager.fromQuery("v") != null ? java.time.Instant.ofEpochMilli(Long.parseLong(manager.fromQuery("v"))) : null);
			return;
		}
		else if (operation.equals("first")) {
			display.first();
			return;
		}
		else if (operation.equals("previous")) {
			display.previous();
			return;
		}
		else if (operation.equals("previousPage")) {
			display.previousPage();
			return;
		}
		else if (operation.equals("next")) {
			display.next();
			return;
		}
		else if (operation.equals("nextPage")) {
			display.nextPage();
			return;
		}
		else if (operation.equals("last")) {
			display.last();
			return;
		}
		else if (operation.equals("page")) {
			display.page(Integer.parseInt(manager.fromQuery("v")));
			return;
		}
		else if (operation.equals("selectEvent")) {
			display.selectEvent(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.EventlineSelectEventParams.class));
			return;
		}
		else if (operation.equals("selectEvents")) {
			display.selectEvents(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.EventlineSelectEventParams[].class)));
			return;
		}
		else if (operation.equals("executeEvent")) {
			display.executeEvent(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.EventlineExecuteEventParams.class));
			return;
		}

		super.execute();
	}
}