/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.documentation.model.data;

import io.intino.alexandria.schemas.Property;
import io.intino.alexandria.ui.documentation.Model;
import io.intino.alexandria.ui.documentation.model.BaseWidget;
import java.util.Collections;

public class NumberWidget
extends BaseWidget {
    public NumberWidget() {
        super("Render formatted numbers with prefixes or suffixes like currency approach.");
        this.facets(Collections.singletonList("Editable"));
    }

    @Override
    protected void addProperties() {
        super.addProperties();
        this.add(Model.property("value", Property.Type.Text, "The initial number to display in the number widget.", new String[0]));
        this.add(Model.property("min", Property.Type.Text, "The minimum number that can be selected.", new String[0]));
        this.add(Model.property("max", Property.Type.Text, "The max number that can be selected.", new String[0]));
        this.add(Model.property("step", Property.Type.Text, "The amount to increment the value by when a user clicks up or down on the scroll bar.", new String[0]));
        this.add(Model.property("prefix", Property.Type.Text, "Text to add before the value.", new String[0]));
        this.add(Model.property("suffix", Property.Type.Text, "Text to add after the value.", new String[0]));
    }

    @Override
    protected void addMethods() {
        super.addMethods();
        this.addMethod(Model.method("value", Collections.emptyList(), "Returns value stored in widget", "java.lang.Double"));
        this.addMethod(Model.method("update", Collections.singletonList(Model.methodParameter("value", "java.lang.Double")), "Updates number value and refresh widget", "Void"));
    }

    @Override
    protected void addEvents() {
        super.addEvents();
        this.addEvent(Model.method("onChange", Collections.singletonList(Model.methodParameter("listener", "io.intino.alexandria.ui.displays.events.ChangeListener")), "This event is fired when widget value changes", "void").facets(Collections.singletonList("Editable")));
    }
}

