/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.StepperInfo;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractStepper;
import io.intino.alexandria.ui.displays.components.Step;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.notifiers.StepperNotifier;
import java.util.List;
import java.util.stream.Collectors;

public class Stepper<DN extends StepperNotifier, B extends Box>
extends AbstractStepper<B> {
    private Listener finishListener = null;
    protected int active = 0;

    public Stepper(B box) {
        super(box);
    }

    public Stepper onFinish(Listener listener) {
        this.finishListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.updateActive();
    }

    @Override
    public <D extends Display> D register(D child) {
        D registered = super.register(child);
        if (child instanceof Step) {
            ((Step)child).visible(true);
        }
        this.updateSteps();
        return registered;
    }

    @Override
    public void add(Step step) {
        this.add(step, "steps");
    }

    protected List<Step> steps() {
        return this.children(Step.class);
    }

    private void updateSteps() {
        int index = 0;
        for (Step step : this.steps()) {
            step._isActive(index == this.active);
            step._isCompleted(index < this.active);
            step.refresh();
            if (index == this.active) {
                step.show();
            }
            ++index;
        }
    }

    public void reset() {
        this.select(0);
    }

    public void select(Step step) {
        this.select(this.posOf(step));
    }

    public void select(int pos) {
        this.active = pos;
        this.updateActive();
        if (this.steps().size() > pos) {
            this.steps().get(pos).refresh();
        }
    }

    public void next() {
        if (this.allowNext()) {
            this.nextVisible();
            this.updateActive();
            this.updateSteps();
            this.checkFinish();
        }
    }

    private void nextVisible() {
        List<Boolean> visibleSteps = this.visibleSteps();
        ++this.active;
        while (this.active < visibleSteps.size() && !visibleSteps.get(this.active).booleanValue()) {
            ++this.active;
        }
    }

    public void back() {
        if (this.allowBack()) {
            this.previousVisible();
            this.updateActive();
            this.updateSteps();
        }
    }

    private void previousVisible() {
        List<Boolean> visibleSteps = this.visibleSteps();
        --this.active;
        while (this.active > 0 && !visibleSteps.get(this.active).booleanValue()) {
            --this.active;
        }
    }

    private boolean allowNext() {
        return (long)this.visiblePosOfActive() < this.visibleStepsCount() - 1L && this.steps().get(this.active).allowNext();
    }

    private boolean allowBack() {
        return this.visiblePosOfActive() > 0 && this.steps().get(this.active).allowBack();
    }

    private int visiblePosOfActive() {
        if (this.steps().size() <= 0) {
            return 0;
        }
        int pos = -1;
        List<Boolean> visibleSteps = this.visibleSteps();
        for (int i = 0; i <= this.active; ++i) {
            if (!visibleSteps.get(i).booleanValue()) continue;
            ++pos;
        }
        return pos;
    }

    private boolean isFinished() {
        return (long)this.active >= this.visibleStepsCount();
    }

    private void checkFinish() {
        if (this.isFinished() && this.finishListener != null) {
            this.finishListener.accept(new Event(this));
        }
    }

    private void updateActive() {
        ((StepperNotifier)this.notifier).refresh(new StepperInfo().active(this.active).allowNext(this.allowNext()).allowBack(this.allowBack()).visibleList(this.visibleSteps()));
    }

    private List<Boolean> visibleSteps() {
        return this.steps().stream().map(Component::isVisible).collect(Collectors.toList());
    }

    private long visibleStepsCount() {
        return this.steps().stream().filter(Component::isVisible).count();
    }

    private int posOf(Step step) {
        List<Step> steps = this.steps();
        for (int i = 0; i < steps.size(); ++i) {
            if (steps.get(i) != step) continue;
            return i;
        }
        return -1;
    }
}

