/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractSelectorToggleBox;
import io.intino.alexandria.ui.displays.notifiers.SelectorToggleBoxNotifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SelectorToggleBox<DN extends SelectorToggleBoxNotifier, B extends Box>
extends AbstractSelectorToggleBox<DN, B> {
    private List<String> selection = new ArrayList<String>();
    private List<String> disabledOptions = new ArrayList<String>();

    public SelectorToggleBox(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.selection(this.selection);
    }

    public void enableOptions(String ... options) {
        this.disabledOptions.removeAll(List.of(options));
        ((SelectorToggleBoxNotifier)this.notifier).refreshDisabledOptions(this.disabledOptions);
    }

    public void disableOptions(String ... options) {
        this.disabledOptions.addAll(List.of(options));
        ((SelectorToggleBoxNotifier)this.notifier).refreshDisabledOptions(this.disabledOptions);
    }

    public List<String> selection() {
        return this.selection;
    }

    @Override
    public void reset() {
        this.select(new String[0]);
    }

    public void selection(String ... options) {
        this.selection(Arrays.asList(options));
    }

    public void selection(List<String> selection) {
        this.selection = selection;
        ((SelectorToggleBoxNotifier)this.notifier).refreshSelection(selection);
    }

    public void select(String ... options) {
        this.updateSelection(Arrays.asList(options));
    }

    public void updateSelection(List<String> options) {
        this.selection(options);
        this.notifySelection();
    }
}

