package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.OpenLayer;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class OpenLayerRequester extends ActionableRequester {

	public OpenLayerRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		OpenLayer display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("execute")) {
			display.execute();
			return;
		}
		else if (operation.equals("openLayer")) {
			display.openLayer();
			return;
		}

		super.execute();
	}
}