package io.intino.alexandria.ui.resources;

import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.ui.pages.ExampleContentPage;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;

import java.util.Base64;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class ExampleContentResource extends io.intino.alexandria.ui.spark.resources.Resource {
	private final UiFrameworkBox box;

	public ExampleContentResource(UiFrameworkBox box, io.intino.alexandria.ui.spark.UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
		this.box = box;
	}

	@Override
	public void execute() throws AlexandriaException {
		super.execute();
		fillDeviceParameter();
		render();
	}

	private void render() {
		String clientId = UUID.randomUUID().toString();
		ExampleContentPage page = new ExampleContentPage();
		page.session = manager.currentSession();
		page.session.browser().onRedirect(location -> manager.redirect(location));
		page.session.browser().requestUrl(manager.requestUrl());
		page.session.whenLogin(new Function<String, String>() {
			@Override
			public String apply(String baseUrl) {
				return ExampleContentResource.this.authenticate(page.session, baseUrl);
			}
		});
		page.session.whenLogout(b -> logout(page.session));
		page.box = box;
		page.clientId = clientId;
		page.googleApiKey = "AIzaSyA8FjeAX36umrYD8Jk2FbRFWqDEulInKIA";
		page.device = parameterValue("device");
		page.token = parameterValue("token");

		if (!page.hasPermissions()) {
			manager.redirect(page.redirectUrl());
			return;
		}

		manager.write(page.execute());
	}

}