/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StreamUtil {
    public static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    public static void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.flush();
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final int copyData(InputStream input, OutputStream output) throws IOException {
        int len;
        int size = 0;
        byte[] buff = new byte[16384];
        while ((len = input.read(buff)) > 0) {
            output.write(buff, 0, len);
            size += len;
        }
        return size;
    }

    public static final byte[] readBytes(InputStream input) throws IOException {
        int nBytes;
        if (input == null) {
            return new byte[0];
        }
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((nBytes = input.read(buffer)) != -1) {
            baos.write(buffer, 0, nBytes);
        }
        return baos.toByteArray();
    }

    public static byte[] calculateHash(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int readed;
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        byte[] buffer = new byte[4096];
        boolean var3 = false;
        while ((readed = inputStream.read(buffer, 0, buffer.length)) > 0) {
            digest.update(buffer, 0, readed);
        }
        return digest.digest();
    }
}

