/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.Selected;
import io.intino.alexandria.ui.displays.components.AbstractTemporalSlider;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.components.slider.Ordinal;
import io.intino.alexandria.ui.displays.components.slider.Range;
import io.intino.alexandria.ui.displays.components.slider.ordinals.DayOrdinal;
import io.intino.alexandria.ui.displays.components.slider.ordinals.HourOrdinal;
import io.intino.alexandria.ui.displays.components.slider.ordinals.MinuteOrdinal;
import io.intino.alexandria.ui.displays.components.slider.ordinals.MonthOrdinal;
import io.intino.alexandria.ui.displays.components.slider.ordinals.YearOrdinal;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.notifiers.TemporalSliderNotifier;
import io.intino.alexandria.ui.model.TimeScale;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TemporalSlider<DN extends TemporalSliderNotifier, B extends Box>
extends AbstractTemporalSlider<DN, B> {
    private Instant min;
    private Instant max;
    private List<Collection> collections = new ArrayList<Collection>();
    private Ordinal.Formatter customFormatter = null;

    public TemporalSlider(B box) {
        super(box);
        this._value((Object)0);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.updateRange();
    }

    public Instant min() {
        return this.min;
    }

    public Instant max() {
        return this.max;
    }

    public void value(Instant instant) {
        this.value(this.toLong(instant));
    }

    @Override
    public void reset() {
        this._value((Object)this.range().min());
    }

    @Override
    public TemporalSlider ordinal(Ordinal ordinal) {
        super.ordinal(ordinal);
        this.updateRange();
        return this;
    }

    public TemporalSlider formatter(Ordinal.Formatter formatter) {
        this.customFormatter = formatter;
        return this;
    }

    public TemporalSlider bindTo(Collection ... collections) {
        this.collections = Arrays.asList(collections);
        return this;
    }

    public TemporalSlider range(Instant min, Instant max) {
        this._range(min, max);
        return this;
    }

    public void moved(long value) {
        ((TemporalSliderNotifier)this.notifier).refreshSelected(this.schemaOf(value));
        ((TemporalSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
    }

    public void update(long value) {
        this.value(value);
    }

    @Override
    void notifyChange() {
        super.notifyChange();
        this.notifyCollections();
    }

    public String formattedValue(long value) {
        return this.format(value);
    }

    @Override
    String format(long value) {
        Ordinal ordinal = this.ordinal();
        if (ordinal == null) {
            ordinal = this.defaultOrdinals().get(0);
        }
        return ordinal != null ? (this.customFormatter != null ? this.customFormatter.format(this.millisOf(value)) : ordinal.formatter(this.language()).format(this.millisOf(value))) : String.valueOf(this.millisOf(value));
    }

    @Override
    public void selectOrdinal(String name) {
        Instant current = this.toInstant(this.millisOf((Long)this.value()));
        super.selectOrdinal(name, this.toLong(this.timeScale(name), current));
    }

    public Timetag timetag() {
        LocalDateTime localDate = this.toInstant(this.millisOf((Long)this.value())).atZone(ZoneOffset.UTC).toLocalDateTime();
        return Timetag.of((LocalDateTime)localDate, (Scale)this.scale());
    }

    public Scale scale() {
        Ordinal ordinal = this.ordinal();
        if (ordinal instanceof YearOrdinal) {
            return Scale.Year;
        }
        if (ordinal instanceof MonthOrdinal) {
            return Scale.Month;
        }
        if (ordinal instanceof DayOrdinal) {
            return Scale.Day;
        }
        if (ordinal instanceof HourOrdinal) {
            return Scale.Hour;
        }
        if (ordinal instanceof MinuteOrdinal) {
            return Scale.Minute;
        }
        return Scale.Day;
    }

    @Override
    protected void _value(Object value) {
        this.value = value instanceof Integer ? Long.valueOf(((Integer)value).intValue()) : value;
    }

    protected TemporalSlider<DN, B> _range(Instant min, Instant max) {
        this.min = min;
        this.max = max;
        this.updateRange();
        return this;
    }

    private long millisOf(long value) {
        return this.timeScale().addTo(this.min, value).toEpochMilli();
    }

    private Instant toInstant(long millis) {
        return Instant.ofEpochMilli(millis);
    }

    private TimeScale timeScale() {
        return this.timeScale(this.ordinal().name());
    }

    private TimeScale timeScale(String ordinal) {
        return TimeScale.valueOf(ordinal);
    }

    private void notifyCollections() {
        this.collections.forEach(c -> c.filter(this.timetag()));
    }

    @Override
    void updateRange() {
        Ordinal ordinal = this.ordinal();
        if (ordinal == null) {
            return;
        }
        long count = this.toLong(this.max);
        this._range(0L, count);
        if (this.notifier != null) {
            ((TemporalSliderNotifier)this.notifier).refreshRange(this.rangeSchema());
            ((TemporalSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
        }
    }

    @Override
    <T extends Selected> void refreshSelected(T schema) {
        ((TemporalSliderNotifier)this.notifier).refreshSelected(schema);
    }

    @Override
    Selected schemaOf(Object value) {
        String formattedValue = this.formattedValue((Long)value);
        return new Selected().value((Long)value).formattedValue(formattedValue);
    }

    @Override
    void notifyListener() {
        if (this.changeListener() == null) {
            return;
        }
        this.changeListener().accept(new ChangeEvent(this, this.toInstant(this.millisOf((Long)this.value()))));
    }

    @Override
    boolean checkRange(Object value) {
        if ((Long)value > this.range.max) {
            return false;
        }
        return (Long)value >= this.range.min;
    }

    @Override
    public void previous() {
        this.value((Long)this.value() - 1L);
    }

    @Override
    public void next() {
        this.value((Long)this.value() + 1L);
    }

    @Override
    boolean canPrevious() {
        return (Long)this.value() > this.range.min;
    }

    @Override
    boolean canNext() {
        return (Long)this.value() < this.range.max;
    }

    @Override
    void nextValue() {
        Long value = (Long)this.value();
        if (value >= this.range.max) {
            if (this.canLoop()) {
                this.value(this.range.min() - 1L);
            } else {
                return;
            }
        }
        this.value(value + 1L);
    }

    @Override
    void _range(long min, long max) {
        this.range = new Range().min(min).max(max);
        long value = (Long)this.value();
        if (value < min) {
            this._value((Object)min);
        }
        if (value > max) {
            this._value((Object)max);
        }
    }

    private long toLong(Instant instant) {
        return this.toLong(this.timeScale(), instant);
    }

    private long toLong(TimeScale timeScale, Instant instant) {
        return timeScale.instantsBetween(this.min, instant) - 1L;
    }
}

