/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Scale;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.EventlineEvent;
import io.intino.alexandria.schemas.EventlineEventGroup;
import io.intino.alexandria.schemas.EventlineExecuteEventParams;
import io.intino.alexandria.schemas.EventlineSelectEventParams;
import io.intino.alexandria.schemas.EventlineToolbarInfo;
import io.intino.alexandria.ui.displays.components.AbstractEventline;
import io.intino.alexandria.ui.displays.events.SelectEvent;
import io.intino.alexandria.ui.displays.events.SelectListener;
import io.intino.alexandria.ui.displays.events.eventline.ExecuteEvent;
import io.intino.alexandria.ui.displays.events.eventline.ExecuteEventListener;
import io.intino.alexandria.ui.displays.events.eventline.SelectEventListEvent;
import io.intino.alexandria.ui.displays.events.eventline.SelectEventListListener;
import io.intino.alexandria.ui.displays.events.eventline.SelectEventListener;
import io.intino.alexandria.ui.displays.notifiers.EventlineNotifier;
import io.intino.alexandria.ui.model.ScaleFormatter;
import io.intino.alexandria.ui.model.eventline.EventlineDatasource;
import io.intino.alexandria.ui.utils.DelayerUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Eventline<DN extends EventlineNotifier, B extends Box>
extends AbstractEventline<B> {
    private EventlineDatasource source;
    private int stepsCount = 10;
    private Arrangement arrangement = Arrangement.Horizontal;
    private long page;
    private List<EventlineEventGroup> pageGroups = new ArrayList<EventlineEventGroup>();
    private final Map<String, List<EventlineDatasource.Event>> events = new HashMap<String, List<EventlineDatasource.Event>>();
    private int selectedPageGroupIndex = 0;
    private final Set<Long> loadedPages = new HashSet<Long>();
    private Instant selectedInstant;
    private SelectListener selectListener = null;
    private SelectEventListener selectEventListener = null;
    private SelectEventListListener selectEventListListener = null;
    private ExecuteEventListener executeEventOperationListener = null;
    private static final int DefaultStepsCount = 10;

    public Eventline(B box) {
        super(box);
    }

    public <DS extends EventlineDatasource> DS source() {
        return (DS)this.source;
    }

    public <DS extends EventlineDatasource> Eventline<DN, B> source(DS source) {
        this.source = source;
        return this;
    }

    public Eventline<DN, B> onSelect(SelectListener listener) {
        this.selectListener = listener;
        return this;
    }

    public Eventline<DN, B> onSelectEvent(SelectEventListener listener) {
        this.selectEventListener = listener;
        return this;
    }

    public Eventline<DN, B> onSelectEvents(SelectEventListListener listener) {
        this.selectEventListListener = listener;
        ((EventlineNotifier)this.notifier).enableSelectEventsAction();
        return this;
    }

    public Eventline<DN, B> onExecuteEventOperation(ExecuteEventListener listener) {
        this.executeEventOperationListener = listener;
        return this;
    }

    public void showLoading() {
        ((EventlineNotifier)this.notifier).showLoading();
    }

    public void hideLoading() {
        ((EventlineNotifier)this.notifier).hideLoading();
    }

    public void select(Instant instant) {
        if (this.source == null) {
            return;
        }
        this.resetPages();
        long page = this.pageOf(instant);
        if (page < 0L) {
            this.first(false);
            return;
        }
        if (page > this.countPages()) {
            this.last(false);
            return;
        }
        Instant min = this.min(this.load(page));
        while (min != null && instant.isBefore(min) && page > 0L) {
            min = this.min(this.load(--page));
        }
        this.page(page - 1L);
        this.update(instant);
        DelayerUtil.execute(this, v -> ((EventlineNotifier)this.notifier).scrollTo(ScaleFormatter.label(instant, this.timezoneOffset(), this.selectedScale(), this.language())), 500);
    }

    public void page(long page) {
        this.page = page;
        if (page < 0L) {
            page = 0L;
        }
        if (page > this.countPages()) {
            this.page = this.countPages() - 1L;
        }
        this.resetPages();
        List<EventlineEventGroup> result = this.arrangement == Arrangement.Vertical ? this.previousEvents() : this.nextEvents();
        ((EventlineNotifier)this.notifier).addEventsAfter(result);
        if (result.size() < this.stepsCount) {
            ((EventlineNotifier)this.notifier).addEventsBefore(this.arrangement == Arrangement.Vertical ? this.nextEvents() : this.previousEvents());
        }
        this.refreshToolbar(page);
        this.updateSelected(result, Index.First);
    }

    public void first() {
        this.first(true);
    }

    public void first(boolean highlight) {
        ((EventlineNotifier)this.notifier).showLoading();
        this.page = -1L;
        this.resetPages();
        ((EventlineNotifier)this.notifier).addEventsAfter(this.updateSelected(this.nextEvents(), Index.First));
        this.refreshToolbar(0L);
        ((EventlineNotifier)this.notifier).hideLoading();
        DelayerUtil.execute(this, v -> ((EventlineNotifier)this.notifier).scrollToStart(highlight), 500);
    }

    public void previous() {
        --this.selectedPageGroupIndex;
        if (this.selectedPageGroupIndex < 0) {
            this.previousPage();
            int n = this.selectedPageGroupIndex = this.pageGroups.isEmpty() ? 0 : this.pageGroups.size() - 1;
        }
        if (this.pageGroups.isEmpty()) {
            return;
        }
        this.update(this.pageGroups.get(this.selectedPageGroupIndex).date());
        DelayerUtil.execute(this, v -> ((EventlineNotifier)this.notifier).scrollTo(ScaleFormatter.label(this.pageGroups.get(this.selectedPageGroupIndex).date(), this.timezoneOffset(), this.selectedScale(), this.language())), 500);
    }

    public void previousPage() {
        if (this.page <= 0L) {
            return;
        }
        if (this.arrangement == Arrangement.Horizontal) {
            ((EventlineNotifier)this.notifier).addEventsBefore(this.updateSelected(this.previousEvents(), Index.First));
        } else {
            ((EventlineNotifier)this.notifier).addEventsAfter(this.updateSelected(this.previousEvents(), Index.Last));
        }
        this.refreshToolbar(this.page);
    }

    public void next() {
        ++this.selectedPageGroupIndex;
        if (this.selectedPageGroupIndex >= this.pageGroups.size()) {
            this.nextPage();
            this.selectedPageGroupIndex = 0;
        }
        if (this.pageGroups.isEmpty()) {
            return;
        }
        this.update(this.pageGroups.get(this.selectedPageGroupIndex).date());
        DelayerUtil.execute(this, v -> ((EventlineNotifier)this.notifier).scrollTo(ScaleFormatter.label(this.pageGroups.get(this.selectedPageGroupIndex).date(), this.timezoneOffset(), this.selectedScale(), this.language())), 500);
    }

    public void nextPage() {
        if (this.page >= this.countPages() - 1L) {
            return;
        }
        if (this.arrangement == Arrangement.Horizontal) {
            ((EventlineNotifier)this.notifier).addEventsAfter(this.updateSelected(this.nextEvents(), Index.Last));
        } else {
            ((EventlineNotifier)this.notifier).addEventsBefore(this.updateSelected(this.nextEvents(), Index.First));
        }
        this.refreshToolbar(this.page);
    }

    public void last() {
        this.last(true);
    }

    public void last(boolean highlight) {
        ((EventlineNotifier)this.notifier).showLoading();
        this.page = this.countPages();
        this.resetPages();
        if (this.arrangement == Arrangement.Horizontal) {
            ((EventlineNotifier)this.notifier).addEventsAfter(this.updateSelected(this.previousEvents(), Index.Last));
        } else {
            ((EventlineNotifier)this.notifier).addEventsBefore(this.updateSelected(this.previousEvents(), Index.First));
        }
        this.refreshToolbar(this.countPages());
        ((EventlineNotifier)this.notifier).hideLoading();
        DelayerUtil.execute(this, v -> ((EventlineNotifier)this.notifier).scrollToEnd(highlight), 500);
    }

    public void update(Instant instant) {
        if (this.selectedInstant == instant) {
            return;
        }
        this.selectedInstant = instant;
        this.updateCurrentEventsIndex(instant);
        if (this.selectListener != null) {
            this.selectListener.accept(new SelectEvent(this, instant));
        }
    }

    public void selectEvent(EventlineSelectEventParams params) {
        if (this.selectEventListener == null) {
            return;
        }
        EventlineDatasource.Event event = this.eventOf(params.date(), params.event());
        if (event == null) {
            return;
        }
        this.selectEventListener.accept(new io.intino.alexandria.ui.displays.events.eventline.SelectEvent(this, event));
    }

    public void selectEvents(List<EventlineSelectEventParams> params) {
        if (this.selectEventListListener == null) {
            return;
        }
        List<EventlineDatasource.Event> events = this.eventsOf(params);
        if (events.isEmpty()) {
            return;
        }
        this.selectEventListListener.accept(new SelectEventListEvent(this, events));
    }

    public void executeEvent(EventlineExecuteEventParams params) {
        if (this.executeEventOperationListener == null) {
            return;
        }
        EventlineDatasource.Event event = this.eventOf(params.date(), params.event());
        if (event == null) {
            return;
        }
        this.executeEventOperationListener.accept(new ExecuteEvent(this, event, params.operation()));
    }

    public void refresh(EventlineDatasource.Event event) {
        ((EventlineNotifier)this.notifier).refreshEvent(this.schemaOf(event));
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.source == null) {
            throw new RuntimeException("Eventline source not defined");
        }
        this.last();
    }

    protected void _arrangement(Arrangement arrangement) {
        this.arrangement = arrangement;
    }

    private List<EventlineEventGroup> nextEvents() {
        ArrayList<EventlineEventGroup> result = new ArrayList<EventlineEventGroup>();
        while (result.size() < this.stepsCount && this.page < this.countPages()) {
            ++this.page;
            result.addAll(this.load(this.page));
        }
        this.pageGroups = result.stream().sorted(this.eventGroupsComparator()).collect(Collectors.toList());
        this.selectedPageGroupIndex = 0;
        if (!result.isEmpty()) {
            this.selectedInstant = ((EventlineEventGroup)result.get(0)).date();
        }
        return this.pageGroups;
    }

    private List<EventlineEventGroup> previousEvents() {
        ArrayList<EventlineEventGroup> result = new ArrayList<EventlineEventGroup>();
        while (result.size() < this.stepsCount && this.page > 0L) {
            --this.page;
            result.addAll(0, this.load(this.page));
        }
        this.pageGroups = result.stream().sorted(this.eventGroupsComparator()).collect(Collectors.toList());
        this.selectedPageGroupIndex = 0;
        if (!result.isEmpty()) {
            this.selectedInstant = ((EventlineEventGroup)result.get(0)).date();
        }
        return this.pageGroups;
    }

    private List<EventlineEventGroup> load(long page) {
        if (this.loadedPages.contains(page)) {
            return Collections.emptyList();
        }
        Scale scale = this.selectedScale();
        Instant from = this.from(page);
        Instant to = LocalDateTime.ofInstant(from, ZoneId.of("UTC")).plus(this.stepsCount, scale.temporalUnit()).toInstant(ZoneOffset.UTC);
        this.loadedPages.add(page);
        return this.register(this.source.events(from, to)).entrySet().stream().map(e -> this.schemaOf((Map.Entry<Instant, List<EventlineDatasource.Event>>)e, page)).collect(Collectors.toList());
    }

    private Comparator<EventlineEventGroup> eventGroupsComparator() {
        if (this.arrangement == Arrangement.Vertical) {
            return (o1, o2) -> o2.date().compareTo(o1.date());
        }
        return Comparator.comparing(EventlineEventGroup::date);
    }

    private EventlineEventGroup schemaOf(Map.Entry<Instant, List<EventlineDatasource.Event>> entry, long page) {
        EventlineEventGroup result = new EventlineEventGroup();
        result.page(page);
        result.date(entry.getKey());
        result.shortDate(ScaleFormatter.shortLabel(entry.getKey(), this.timezoneOffset(), this.selectedScale(), this.language()));
        result.longDate(ScaleFormatter.label(entry.getKey(), this.timezoneOffset(), this.selectedScale(), this.language()));
        result.events(entry.getValue().stream().map(this::schemaOf).sorted(this.eventsComparator()).collect(Collectors.toList()));
        return result;
    }

    private Comparator<EventlineEvent> eventsComparator() {
        if (this.arrangement == Arrangement.Vertical) {
            return (o1, o2) -> o2.date().compareTo(o1.date());
        }
        return Comparator.comparing(EventlineEvent::date);
    }

    private EventlineEvent schemaOf(EventlineDatasource.Event event) {
        EventlineEvent result = new EventlineEvent();
        result.id(event.id());
        result.date(event.date());
        result.shortDate(ScaleFormatter.shortLabel(event.date(), this.timezoneOffset(), this.selectedScale(), this.language()));
        result.longDate(ScaleFormatter.label(event.date(), this.timezoneOffset(), this.selectedScale(), this.language()));
        result.label(event.label());
        result.category(event.category());
        result.color(event.color());
        result.icon(event.icon());
        result.iconTitle(event.iconTitle());
        result.comments(event.comments());
        result.operations(event.operations());
        return result;
    }

    private Scale selectedScale() {
        return this.source.scale();
    }

    private void refreshToolbar(long page) {
        ((EventlineNotifier)this.notifier).refreshToolbar(this.toolbar(page));
    }

    private EventlineToolbarInfo toolbar(long page) {
        Scale scale = this.selectedScale();
        Instant date = this.from(page);
        EventlineToolbarInfo result = new EventlineToolbarInfo();
        result.label(ScaleFormatter.label(date, this.timezoneOffset(), scale, this.language()));
        result.page(page);
        result.countPages(this.countPages());
        result.loadedPages(new ArrayList<Long>(this.loadedPages));
        result.canPrevious(page > 0L);
        result.canNext(page < this.countPages() - 1L);
        return result;
    }

    private long countPages() {
        Scale scale = this.selectedScale();
        long steps = scale.temporalUnit().between(this.source.from(), this.source.to()) + 1L;
        return this.pageOf(steps);
    }

    private int pageOf(long index) {
        return (int)(Math.floor(index / (long)this.stepsCount) + (double)(index % (long)this.stepsCount > 0L ? 1 : 0));
    }

    private Instant from(long page) {
        return LocalDateTime.ofInstant(this.source.from(), ZoneOffset.UTC).plus(page * (long)this.stepsCount, this.selectedScale().temporalUnit()).toInstant(ZoneOffset.UTC);
    }

    private long pageOf(Instant instant) {
        return this.pageOf(this.selectedScale().temporalUnit().between(this.source.from(), instant));
    }

    private long countSteps() {
        return this.selectedScale().temporalUnit().between(this.source.from(), this.source.to());
    }

    private long firstPage() {
        return this.countPages();
    }

    private void resetPages() {
        this.loadedPages.clear();
        this.pageGroups.clear();
        this.events.clear();
        ((EventlineNotifier)this.notifier).resetEvents();
    }

    private Instant min(List<EventlineEventGroup> groups) {
        if (groups.size() <= 0) {
            return null;
        }
        return groups.get(0).date();
    }

    private Instant max(List<EventlineEventGroup> groups) {
        if (groups.size() <= 0) {
            return null;
        }
        return groups.get(groups.size() - 1).date();
    }

    private List<EventlineEventGroup> updateSelected(List<EventlineEventGroup> events, Index index) {
        if (events.isEmpty()) {
            return events;
        }
        this.update(events.get(this.arrangement == Arrangement.Vertical ? events.size() - 1 : 0).date());
        return events;
    }

    private void updateCurrentEventsIndex(Instant instant) {
        int index = this.pageGroupIndex(instant);
        if (index > 0) {
            this.selectedPageGroupIndex = index;
        }
    }

    private int pageGroupIndex(Instant instant) {
        for (int i = 0; i < this.pageGroups.size(); ++i) {
            if (this.pageGroups.get(i).date().getEpochSecond() != instant.getEpochSecond()) continue;
            return i;
        }
        return -1;
    }

    private List<EventlineDatasource.Event> eventsOf(List<EventlineSelectEventParams> params) {
        return params.stream().map(p -> this.eventOf(p.date(), p.event())).collect(Collectors.toList());
    }

    private EventlineDatasource.Event eventOf(Instant instant, String id) {
        List events = this.events.getOrDefault(this.label(instant), Collections.emptyList());
        if (events.isEmpty()) {
            return null;
        }
        return events.stream().filter(e -> e.id().equals(id)).findFirst().orElse(null);
    }

    @Override
    private Map<Instant, List<EventlineDatasource.Event>> register(Map<Instant, List<EventlineDatasource.Event>> eventList) {
        eventList.forEach((key, value) -> {
            String date = this.label((Instant)key);
            if (!this.events.containsKey(date)) {
                this.events.put(date, new ArrayList());
            }
            this.events.get(date).addAll((Collection<EventlineDatasource.Event>)value);
        });
        return eventList;
    }

    private String label(Instant instant) {
        return ScaleFormatter.label(instant, this.timezoneOffset(), this.selectedScale(), this.language());
    }

    public static enum Arrangement {
        Vertical,
        Horizontal;

    }

    private static enum Index {
        First,
        Last;

    }
}

