/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.DocumentEditorCollaboraInfo;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.displays.components.AbstractDocumentEditorCollabora;
import io.intino.alexandria.ui.displays.components.documenteditor.CollaboraServer;
import io.intino.alexandria.ui.displays.components.documenteditor.DocumentManager;
import io.intino.alexandria.ui.displays.notifiers.DocumentEditorCollaboraNotifier;

public class DocumentEditorCollabora<DN extends DocumentEditorCollaboraNotifier, B extends Box>
extends AbstractDocumentEditorCollabora<DN, B> {
    private CollaboraServer server;
    private String documentId;
    private String editorUrl;

    public DocumentEditorCollabora(B box) {
        super(box);
    }

    public DocumentEditorCollabora<DN, B> document(String id) {
        this._document(id);
        return this;
    }

    public DocumentEditorCollabora<DN, B> documentManager(DocumentManager documentManager) {
        this.server.documentManager(this.accessToken(), documentManager);
        return this;
    }

    public DocumentEditorCollabora<DN, B> editorUrl(String url) {
        this._editorUrl(url);
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.server = new CollaboraServer((AlexandriaUiBox)((Object)this.box())).listen();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.server.register(this.accessToken());
        ((DocumentEditorCollaboraNotifier)this.notifier).refresh(new DocumentEditorCollaboraInfo().editorUrl(this.editorUrl).accessToken(this.accessToken()).documentUrl(this.documentUrl()));
    }

    @Override
    public void unregister() {
        super.unregister();
        this.server.unregister(this.accessToken());
    }

    protected DocumentEditorCollabora<DN, B> _editorUrl(String url) {
        this.editorUrl = url;
        return this;
    }

    protected DocumentEditorCollabora<DN, B> _document(String id) {
        this.documentId = id;
        return this;
    }

    private String documentUrl() {
        if (this.documentId == null) {
            return null;
        }
        return this.server.url(this.session().browser().baseUrl(), this.documentId);
    }

    private String accessToken() {
        return this.session().id() + "-" + this.id();
    }
}

