/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.spark;

import io.intino.alexandria.http.pushservice.Client;
import io.intino.alexandria.http.spark.PushService;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UISession;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import spark.Request;
import spark.Response;

public class UISparkManager
extends SparkManager<io.intino.alexandria.ui.services.push.PushService> {
    private final AuthService authService;
    private final boolean hasUserHome;
    public static final String KonosUserHomePath = "/konos/user";

    public UISparkManager(Request request, Response response, io.intino.alexandria.ui.services.push.PushService pushService, AuthService authService, boolean hasUserHome) {
        super((PushService)pushService, request, response);
        this.authService = authService;
        this.hasUserHome = hasUserHome;
    }

    public AuthService authService() {
        return this.authService;
    }

    public void linkToThread(UIClient client) {
        ((io.intino.alexandria.ui.services.push.PushService)this.pushService).linkToThread(client);
    }

    public void unlinkFromThread() {
        ((io.intino.alexandria.ui.services.push.PushService)this.pushService).unlinkFromThread();
    }

    public void unRegister(UIClient client) {
        ((io.intino.alexandria.ui.services.push.PushService)this.pushService).unRegister((Client)client);
    }

    public String userHomePath() {
        return this.hasUserHome ? KonosUserHomePath : "";
    }

    public String requestUrl() {
        String requestUri;
        Object result = this.baseUrl();
        if (!((String)result).endsWith("/")) {
            result = (String)result + "/";
        }
        result = (String)result + ((requestUri = this.request.raw().getRequestURI()) != null && requestUri.startsWith("/") ? requestUri.substring(1) : requestUri);
        return this.withQueryString((String)result);
    }

    private String withQueryString(String result) {
        String queryString = this.request.raw().getQueryString();
        if (queryString == null || queryString.isEmpty()) {
            return result;
        }
        return result + "?" + queryString;
    }

    public UISession currentSession() {
        return (UISession)super.currentSession();
    }

    public UISession session(String id) {
        return (UISession)((io.intino.alexandria.ui.services.push.PushService)this.pushService()).session(id);
    }

    public UIClient client(String id) {
        return (UIClient)((io.intino.alexandria.ui.services.push.PushService)this.pushService).client(id);
    }

    public UIClient currentClient() {
        return (UIClient)((io.intino.alexandria.ui.services.push.PushService)this.pushService).currentClient();
    }

    public String languageFromHeader() {
        String language = this.request.raw().getHeader("Accept-Language");
        return language != null ? this.languageOf(language.split(",")[0]) : null;
    }

    public String ipAddressFromHeader() {
        HttpServletRequest raw = this.request.raw();
        String ipAddress = raw.getHeader("Remote_Addr");
        if (ipAddress == null || ipAddress.isEmpty()) {
            ipAddress = raw.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ipAddress != null && !ipAddress.isEmpty()) {
            return ipAddress;
        }
        return raw.getRemoteAddr();
    }

    public String languageFromUrl() {
        return this.languageOf(this.request.queryParams("language"));
    }

    private String languageOf(String language) {
        if (language == null) {
            return null;
        }
        return Locale.forLanguageTag(language).getLanguage().toLowerCase();
    }

    public Map<String, String> cookies() {
        return this.request.cookies();
    }

    public void redirect(String location) {
        this.currentSession().browser().add("callback", this.requestUrl());
        super.redirect(location);
    }
}

