/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.eventline;

import io.intino.alexandria.Scale;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface EventlineDatasource {
    public String name();

    public Map<Instant, List<Event>> events(Instant var1, Instant var2);

    public Scale scale();

    public Instant from();

    public Instant to();

    default public Instant previous(Instant date) {
        return this.previous(date, 1L);
    }

    default public Instant previous(Instant date, long count) {
        return LocalDateTime.ofInstant(date, ZoneOffset.UTC).minus(count, this.scale().temporalUnit()).toInstant(ZoneOffset.UTC);
    }

    default public Instant next(Instant date) {
        return this.next(date, 1L);
    }

    default public Instant next(Instant date, long count) {
        return LocalDateTime.ofInstant(date, ZoneOffset.UTC).plus(count, this.scale().temporalUnit()).toInstant(ZoneOffset.UTC);
    }

    public static class Event {
        private final String id;
        private final Instant date;
        private final String label;
        private final String category;
        private String color;
        private String icon = "CheckBoxOutlineBlank";
        private String iconTitle = "";
        private String comments;
        private List<String> operationList = new ArrayList<String>();

        public Event(String id, Instant date, String label) {
            this(id, date, label, null, "#ed6c02");
        }

        public Event(String id, Instant date, String label, String category) {
            this(id, date, label, category, "#ed6c02");
        }

        public Event(String id, Instant date, String label, String category, String color) {
            this.id = id;
            this.date = date;
            this.label = label;
            this.category = category;
            this.color = color;
        }

        public String id() {
            return this.id;
        }

        public Instant date() {
            return this.date;
        }

        public String label() {
            return this.label;
        }

        public String category() {
            return this.category;
        }

        public String color() {
            return this.color;
        }

        public Event color(String color) {
            this.color = color;
            return this;
        }

        public Event icon(String icon, String title) {
            this.icon = icon;
            this.iconTitle = title;
            return this;
        }

        public String icon() {
            return this.icon;
        }

        public String iconTitle() {
            return this.iconTitle;
        }

        public String comments() {
            return this.comments;
        }

        public Event comments(String comments) {
            this.comments = comments;
            return this;
        }

        public Event operations(List<String> operationList) {
            this.operationList = operationList;
            return this;
        }

        public List<String> operations() {
            return this.operationList;
        }

        public static enum Symbol {
            Circle,
            Square,
            Diamond,
            Triangle;

        }
    }
}

