/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.ui.displays.templates.AbstractReelExamplesMold;
import io.intino.alexandria.ui.model.reel.ReelDatasource;
import io.intino.alexandria.ui.model.reel.SignalDefinition;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReelExamplesMold
extends AbstractReelExamplesMold<UiFrameworkBox> {
    public ReelExamplesMold(UiFrameworkBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.reel1.source(this.source());
        this.reel1.refresh();
    }

    private ReelDatasource source() {
        return new ReelDatasource(){

            @Override
            public String name() {
                return "rds1";
            }

            @Override
            public List<SignalDefinition> signals() {
                return List.of(ReelExamplesMold.this.signalOf("s1", "status.usage.logical.reads", "red"), ReelExamplesMold.this.signalOf("s2", "status.usage.logical.writes", "red"), SignalDefinition.empty("se1"), ReelExamplesMold.this.signalOf("s3", "status.temperature.internal", "green"), ReelExamplesMold.this.signalOf("s4", "status.temperature.external", "green"), SignalDefinition.empty("se2"), ReelExamplesMold.this.signalOf("s5", "status.fan", "blue"));
            }

            @Override
            public ReelDatasource.Signal signal(final SignalDefinition definition) {
                return new ReelDatasource.Signal(){

                    @Override
                    public SignalDefinition definition() {
                        return definition;
                    }

                    @Override
                    public String reel(Scale scale, Instant start, Instant end) {
                        Object result = "";
                        for (int i = 0; i < 24; ++i) {
                            result = (String)result + (i % 2 != 0 ? " " : "-");
                        }
                        return result;
                    }

                    @Override
                    public Map<Instant, List<ReelDatasource.Annotation>> annotations(final Scale scale, Instant start, Instant end) {
                        final LocalDateTime date = LocalDateTime.ofInstant(end, ZoneOffset.UTC);
                        return new LinkedHashMap<Instant, List<ReelDatasource.Annotation>>(){
                            {
                                this.put(date.minus(18L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), List.of(this.annotationOf("Warning value")));
                                this.put(date.minus(10L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), List.of(this.annotationOf("Out of range")));
                                this.put(date.minus(1L, scale.temporalUnit()).toInstant(ZoneOffset.UTC), List.of(this.annotationOf("Value is not valid", "green")));
                            }

                            private ReelDatasource.Annotation annotationOf(String label) {
                                return new ReelDatasource.Annotation(label);
                            }

                            private ReelDatasource.Annotation annotationOf(String label, String color) {
                                return new ReelDatasource.Annotation(label, color);
                            }
                        };
                    }
                };
            }

            @Override
            public List<Scale> scales() {
                return List.of(Scale.Hour, Scale.Day, Scale.Week, Scale.Month, Scale.Year);
            }

            @Override
            public Instant from(Scale scale) {
                return LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).minus(500L, scale.temporalUnit()).toInstant(ZoneOffset.UTC);
            }

            @Override
            public Instant to(Scale scale) {
                return Instant.now();
            }

            @Override
            public Instant previous(Scale scale, Instant date) {
                return LocalDateTime.ofInstant(date, ZoneOffset.UTC).minus(1L, scale.temporalUnit()).toInstant(ZoneOffset.UTC);
            }

            @Override
            public Instant next(Scale scale, Instant date) {
                return LocalDateTime.ofInstant(date, ZoneOffset.UTC).plus(1L, scale.temporalUnit()).toInstant(ZoneOffset.UTC);
            }
        };
    }

    private SignalDefinition signalOf(String name, String label, String color) {
        return new SignalDefinition().name(name).add("es", label).color(color);
    }
}

