/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.SignDocument;
import io.intino.alexandria.ui.displays.events.SignErrorEvent;
import io.intino.alexandria.ui.displays.events.SignEvent;
import io.intino.alexandria.ui.displays.templates.AbstractDigitalSignatureExamplesMold;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DigitalSignatureExamplesMold
extends AbstractDigitalSignatureExamplesMold<UiFrameworkBox> {
    private final List<Resource> documentsToSign = new ArrayList<Resource>();

    public DigitalSignatureExamplesMold(UiFrameworkBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.signText.text("hola mundo");
        this.signDocument.document(DigitalSignatureExamplesMold.class.getResource("/data/example.pdf"));
        this.signText.onSign(this::refreshSignature);
        this.signDocument.onSign(this::refreshSignature);
        this.signText.onError(this::refreshError);
        this.signDocument.onError(this::refreshError);
        this.signDocumentsField.onChange(e -> {
            if (this.documentsToSign.contains(e.item())) {
                return;
            }
            this.documentsToSign.add((Resource)e.item());
            this.signDocuments.readonly(false);
            this.signaturesBlock.visible(false);
        });
        this.signDocumentsField.onRemove(e -> {
            this.documentsToSign.remove(e.index());
            this.signDocuments.readonly(this.documentsToSign.isEmpty());
            this.signaturesBlock.visible(false);
        });
        this.signDocuments.onSign(this::refreshSignatures);
        this.signDocuments.onError(this::refreshBatchError);
        this.signDocuments.documentProvider(this.batchProvider());
    }

    private void refreshSignature(SignEvent e) {
        this.signature.value(e.signature());
        this.signedBy.value(e.info().getUsername());
        this.error.value(null);
    }

    private void refreshSignatures(SignEvent e) {
        this.signatures.clear();
        this.signatures.addAll(new ArrayList<String>(e.signatures().values()));
        this.signaturesBlock.visible(true);
        this.batchSignedBy.value(e.info().getUsername());
        this.batchError.value(null);
    }

    private void refreshError(SignErrorEvent e) {
        this.signature.value(null);
        this.signedBy.value(null);
        this.error.value("Error code: " + e.code() + "; message: " + e.message());
    }

    private void refreshBatchError(SignErrorEvent e) {
        this.signatures.clear();
        this.signaturesBlock.visible(false);
        this.batchSignedBy.value(null);
        this.batchError.value("Error code: " + e.code() + "; message: " + e.message());
    }

    private SignDocument.BatchProvider batchProvider() {
        return () -> this.documentsToSign.stream().map(r -> {
            try {
                r.stream().reset();
                return r.stream();
            }
            catch (IOException ex) {
                Logger.error((Throwable)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

