/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.collection.behaviors;

import io.intino.alexandria.schemas.CollectionMoreItems;
import io.intino.alexandria.ui.displays.components.DynamicTable;
import io.intino.alexandria.ui.displays.components.collection.Collection;
import io.intino.alexandria.ui.displays.components.collection.behaviors.CollectionBehavior;
import io.intino.alexandria.ui.displays.components.collection.loaders.DynamicTableItemLoader;
import io.intino.alexandria.ui.model.datasource.DynamicTableDatasource;
import io.intino.alexandria.ui.model.dynamictable.Section;
import java.util.List;

public class DynamicTableCollectionBehavior<Item>
extends CollectionBehavior<DynamicTableDatasource<Item>, Item, DynamicTableItemLoader<Item>> {
    private int page = 0;
    public static final int DefaultPageSize = 20;

    public DynamicTableCollectionBehavior(DynamicTable collection) {
        super(collection);
    }

    public DynamicTableCollectionBehavior(Collection collection) {
        super(collection);
    }

    public DynamicTableCollectionBehavior setup(DynamicTableDatasource<Item> source) {
        return this.setup(source, 20);
    }

    public DynamicTableCollectionBehavior setup(DynamicTableDatasource<Item> source, int pageSize) {
        if (source == null) {
            return this;
        }
        this.itemLoader = new DynamicTableItemLoader<Item>(source, pageSize);
        return this;
    }

    public String dimension() {
        return ((DynamicTableItemLoader)this.itemLoader).dimension();
    }

    public DynamicTableCollectionBehavior dimension(String dimension) {
        ((DynamicTableItemLoader)this.itemLoader).dimension(dimension);
        return this;
    }

    public String drill() {
        return ((DynamicTableItemLoader)this.itemLoader).drill();
    }

    public DynamicTableCollectionBehavior drill(String drill) {
        ((DynamicTableItemLoader)this.itemLoader).drill(drill);
        return this;
    }

    public DynamicTableCollectionBehavior section(Section section) {
        ((DynamicTableItemLoader)this.itemLoader).section(section);
        return this;
    }

    public DynamicTableCollectionBehavior row(String row) {
        ((DynamicTableItemLoader)this.itemLoader).row(row);
        return this;
    }

    public void page(int pos) {
        this.computeUpdate(e -> {
            this.page = pos;
        });
    }

    public int pageSize() {
        return ((DynamicTableItemLoader)this.itemLoader).pageSize();
    }

    public void pageSize(int size) {
        this.computeUpdate(e -> {
            DynamicTableItemLoader itemLoader = (DynamicTableItemLoader)this.itemLoader();
            itemLoader.pageSize(size);
        });
    }

    public synchronized void moreItems(CollectionMoreItems info) {
        List items = ((DynamicTableItemLoader)this.itemLoader).moreItems(info.start(), info.stop());
        this.collection().insert(items, info.start());
    }

    @Override
    public long itemCount() {
        return ((DynamicTableItemLoader)this.itemLoader).itemCount();
    }

    @Override
    public void update() {
        this.collection().loading(true);
        this.updateSections();
        this.updateItems();
        this.collection().loading(false);
    }

    void updateSections() {
        DynamicTable collection = (DynamicTable)this.collection();
        collection.refreshSections(this.sections());
    }

    private void updateItems() {
        DynamicTableItemLoader itemLoader = (DynamicTableItemLoader)this.itemLoader();
        int count = itemLoader.pageCount();
        while (this.page > count && this.page > 0) {
            --this.page;
        }
        if (count == 0) {
            return;
        }
        this.collection().add(itemLoader.page(this.page));
    }

    public List<Section> sections() {
        return ((DynamicTableItemLoader)this.itemLoader()).sections();
    }
}

