/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.ReelFetch;
import io.intino.alexandria.schemas.ReelNavigationInfo;
import io.intino.alexandria.schemas.ReelSetup;
import io.intino.alexandria.schemas.ReelSignal;
import io.intino.alexandria.schemas.ReelSignalAnnotation;
import io.intino.alexandria.schemas.ReelSignalSorting;
import io.intino.alexandria.schemas.ReelSignalStep;
import io.intino.alexandria.ui.displays.components.AbstractReel;
import io.intino.alexandria.ui.displays.events.SelectEvent;
import io.intino.alexandria.ui.displays.events.SelectListener;
import io.intino.alexandria.ui.displays.notifiers.ReelNotifier;
import io.intino.alexandria.ui.model.ScaleFormatter;
import io.intino.alexandria.ui.model.reel.ReelDatasource;
import io.intino.alexandria.ui.model.reel.SignalDefinition;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Reel<DN extends ReelNotifier, B extends Box>
extends AbstractReel<B> {
    private ReelDatasource source;
    private List<ReelSignalSorting> signalsSorting;
    private final Map<Scale, Instant> selectedInstants = new HashMap<Scale, Instant>();
    private Scale selectedScale = null;
    private int stepsCount = 24;
    private SelectListener selectListener;
    private SelectListener selectScaleListener;
    private static final int DefaultStepsCount = 24;

    public Reel(B box) {
        super(box);
    }

    public <DS extends ReelDatasource> Reel<DN, B> source(DS source) {
        this.source = source;
        return this;
    }

    public List<ReelSignalSorting> signalsSorting() {
        return this.signalsSorting;
    }

    public Reel<DN, B> signalsSorting(List<ReelSignalSorting> signalsSorting) {
        this.signalsSorting = signalsSorting;
        ((ReelNotifier)this.notifier).refreshSignalsSorting(signalsSorting);
        return this;
    }

    public Reel<DN, B> stepsCount(int count) {
        this.stepsCount = count;
        return this;
    }

    public Reel<DN, B> onSelect(SelectListener listener) {
        this.selectListener = listener;
        return this;
    }

    public Reel<DN, B> onSelectScale(SelectListener listener) {
        this.selectScaleListener = listener;
        return this;
    }

    public Reel<DN, B> select(Instant instant) {
        if (this.source == null) {
            return this;
        }
        if (this.selectedInstant(this.selectedScale()) != null && this.selectedInstant(this.selectedScale()).equals(instant)) {
            return this;
        }
        this.selectInstant(this.selectedScale(), instant);
        return this;
    }

    public void select(Scale scale) {
        this.changeScale(scale);
    }

    public void changeScale(String scale) {
        this.changeScale(Scale.valueOf((String)scale));
    }

    public void changeScale(Scale scale) {
        if (this.selectedScale == scale) {
            return;
        }
        this.selectedScale = scale;
        this.refreshSignals();
        this.refreshNavigation();
        if (this.selectScaleListener != null) {
            this.selectScaleListener.accept(new SelectEvent(this, this.selectedScale));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.source == null) {
            throw new RuntimeException("Reel source not defined");
        }
        ((ReelNotifier)this.notifier).setup(new ReelSetup().name(this.source.name()).scales(this.source.scales().stream().map(Enum::name).collect(Collectors.toList())).signals(this.source.signals().stream().map(this::schemaOf).collect(Collectors.toList())).navigation(this.navigation()));
    }

    public void fetch(ReelFetch fetch) {
    }

    private Scale selectedScale() {
        return this.selectedScale != null ? this.selectedScale : this.source.scales().get(0);
    }

    private void selectInstant(Scale scale, Instant value) {
        this.selectedInstants.put(scale, value);
        this.refreshSignals();
        if (this.selectListener != null) {
            this.selectListener.accept(new SelectEvent(this, value));
        }
    }

    private void refreshSignals() {
        ((ReelNotifier)this.notifier).refreshSignals(this.source.signals().stream().map(this::schemaOf).collect(Collectors.toList()));
    }

    private void refreshNavigation() {
        ((ReelNotifier)this.notifier).refreshNavigation(this.navigation());
    }

    private ReelNavigationInfo navigation() {
        Scale scale = this.selectedScale();
        Instant current = this.source.from(scale);
        Instant to = this.source.to(scale);
        int steps = 0;
        while (current != to && current.isBefore(to)) {
            ++steps;
            current = this.source.next(scale, current);
        }
        return new ReelNavigationInfo().steps(steps);
    }

    private ReelSignal schemaOf(SignalDefinition definition) {
        return this.schemaOf(this.signal(definition));
    }

    private ReelSignal schemaOf(ReelDatasource.Signal signal) {
        SignalDefinition definition = signal.definition();
        Scale scale = this.selectedScale();
        Instant to = this.selectedInstant(scale);
        Instant from = LocalDateTime.ofInstant(to, ZoneId.of("UTC")).minus(this.stepsCount - 1, scale.temporalUnit()).toInstant(ZoneOffset.UTC);
        String reel = signal.reel(scale, from, to);
        Map<Instant, List<ReelDatasource.Annotation>> annotations = signal.annotations(scale, from, to);
        return new ReelSignal().name(definition.name()).type(definition.type().name()).label(definition.label(this.language())).color(definition.color()).steps(this.stepsOf(this.fillWithZeros(reel), from)).annotations(this.annotationsOf(annotations));
    }

    private String fillWithZeros(String reel) {
        return String.format("%1$" + this.stepsCount + "s", reel);
    }

    private List<ReelSignalStep> stepsOf(String reel, Instant from) {
        Scale scale = this.selectedScale();
        Instant current = from;
        ArrayList<ReelSignalStep> result = new ArrayList<ReelSignalStep>();
        for (int i = 0; i < reel.length(); ++i) {
            result.add(new ReelSignalStep().value(String.valueOf(reel.charAt(i))).date(ScaleFormatter.label(current, this.timezoneOffset(), scale, this.language())));
            current = this.source.next(scale, current);
        }
        return result;
    }

    private List<ReelSignalAnnotation> annotationsOf(Map<Instant, List<ReelDatasource.Annotation>> annotations) {
        return annotations.entrySet().stream().map(this::annotationOf).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ReelSignalAnnotation annotationOf(Map.Entry<Instant, List<ReelDatasource.Annotation>> entry) {
        Scale scale = this.selectedScale();
        List<ReelDatasource.Annotation> annotationList = entry.getValue();
        if (annotationList.isEmpty()) {
            return null;
        }
        return new ReelSignalAnnotation().date(ScaleFormatter.label(this.normalize(entry.getKey(), scale), this.timezoneOffset(), scale, this.language())).entries(this.entriesOf(annotationList)).color(annotationList.get(0).color());
    }

    private Instant normalize(Instant date, Scale scale) {
        return new Timetag(date, scale).instant();
    }

    private List<String> entriesOf(List<ReelDatasource.Annotation> annotationList) {
        return annotationList.stream().map(ReelDatasource.Annotation::label).collect(Collectors.toList());
    }

    private ReelDatasource.Signal signal(SignalDefinition definition) {
        return this.source.signal(definition);
    }

    private Instant selectedInstant() {
        return this.selectedInstant(this.selectedScale());
    }

    private Instant selectedInstant(Scale scale) {
        return this.selectedInstants.getOrDefault(scale, this.source.to(this.selectedScale()));
    }
}

