/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Resource;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.AbstractFileEditable;
import io.intino.alexandria.ui.displays.components.File;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.notifiers.FileEditableNotifier;
import io.intino.alexandria.ui.spark.UIFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class FileEditable<DN extends FileEditableNotifier, B extends Box>
extends AbstractFileEditable<DN, B>
implements Editable<DN, B> {
    private boolean readonly;
    protected Listener uploadingListener = null;
    protected ChangeListener changeListener = null;
    private File preview;

    public FileEditable(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.createPreview();
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public void reload() {
        ((FileEditableNotifier)this.notifier).refresh(this.info());
    }

    @Override
    public FileEditable<DN, B> focus() {
        ((FileEditableNotifier)this.notifier).refreshFocused(true);
        return this;
    }

    @Override
    public FileEditable<DN, B> readonly(boolean readonly) {
        this._readonly(readonly);
        ((FileEditableNotifier)this.notifier).refreshReadonly(readonly);
        return this;
    }

    public FileEditable<DN, B> onUploading(Listener listener) {
        this.uploadingListener = listener;
        return this;
    }

    @Override
    public FileEditable<DN, B> onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    @Override
    public void refresh() {
        this.refreshPreview();
        ((FileEditableNotifier)this.notifier).refresh(this.info());
    }

    public void notifyUploading() {
        if (this.uploadingListener != null) {
            this.uploadingListener.accept(new Event(this));
        }
    }

    public void notifyChange(Resource value) {
        if (this.changeListener != null) {
            this.changeListener.accept(new ChangeEvent(this, value));
        }
    }

    public UIFile downloadFile() {
        final URL value = this.value();
        return new UIFile(){

            @Override
            public String label() {
                if (FileEditable.this.filename() != null) {
                    return URLEncoder.encode(FileEditable.this.filename(), StandardCharsets.UTF_8);
                }
                String path = value.getPath();
                return path.contains("/") ? path.substring(path.lastIndexOf("/") + 1) : path;
            }

            @Override
            public InputStream content() {
                try {
                    return value.openStream();
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                    return new ByteArrayInputStream(new byte[0]);
                }
            }
        };
    }

    protected FileEditable<DN, B> _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    private void createPreview() {
        this.preview = (File)new File(this.box()).id(UUID.randomUUID().toString());
        this.add(this.preview, "__elements");
    }

    private void refreshPreview() {
        this.preview.visible(this.value() != null);
        this.preview.value(this.value(), this.mimeType());
    }
}

