package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.SignAction;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class SignActionRequester extends ActionableRequester {

	public SignActionRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SignAction display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("signing")) {
			display.signing();
			return;
		}
		else if (operation.equals("success")) {
			display.success(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.SignActionSignatureSuccess.class));
			return;
		}
		else if (operation.equals("failure")) {
			display.failure(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.SignActionSignatureFailure.class));
			return;
		}

		super.execute();
	}
}