package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.SelectorTabs;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class SelectorTabsRequester extends BaseSelectorRequester {

	public SelectorTabsRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SelectorTabs display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("select")) {
			display.select(Integer.parseInt(manager.fromQuery("v")));
			return;
		}
		else if (operation.equals("selectByName")) {
			display.selectByName(manager.fromQuery("v"));
			return;
		}

		super.execute();
	}
}