package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Eventline;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.spark.UISparkManager;

public class EventlinePushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		Eventline display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("update")) {
			display.update(data != null ? java.time.Instant.ofEpochMilli(Long.parseLong(data)) : null);
			return;
		}
		else if (operation.equals("first")) {
			display.first();
			return;
		}
		else if (operation.equals("previous")) {
			display.previous();
			return;
		}
		else if (operation.equals("previousPage")) {
			display.previousPage();
			return;
		}
		else if (operation.equals("next")) {
			display.next();
			return;
		}
		else if (operation.equals("nextPage")) {
			display.nextPage();
			return;
		}
		else if (operation.equals("last")) {
			display.last();
			return;
		}
		else if (operation.equals("page")) {
			display.page(Integer.parseInt(data));
			return;
		}
		else if (operation.equals("selectEvent")) {
			display.selectEvent(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.EventlineSelectEventParams.class));
			return;
		}
		else if (operation.equals("selectEvents")) {
			display.selectEvents(java.util.List.of(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.EventlineSelectEventParams[].class)));
			return;
		}
		else if (operation.equals("executeEvent")) {
			display.executeEvent(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.EventlineExecuteEventParams.class));
			return;
		}

		super.execute(client, message);
	}

}